/*
 * Decompiled with CFR 0.152.
 */
package com.seam.api.resources.thermostats.requests;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Objects;
import java.util.Optional;

@JsonDeserialize(builder=Builder.class)
public final class ThermostatsHeatRequest {
    private final String deviceId;
    private final Optional<Double> heatingSetPointCelsius;
    private final Optional<Double> heatingSetPointFahrenheit;
    private final Optional<Boolean> sync;

    private ThermostatsHeatRequest(String deviceId, Optional<Double> heatingSetPointCelsius, Optional<Double> heatingSetPointFahrenheit, Optional<Boolean> sync) {
        this.deviceId = deviceId;
        this.heatingSetPointCelsius = heatingSetPointCelsius;
        this.heatingSetPointFahrenheit = heatingSetPointFahrenheit;
        this.sync = sync;
    }

    @JsonProperty(value="device_id")
    public String getDeviceId() {
        return this.deviceId;
    }

    @JsonProperty(value="heating_set_point_celsius")
    public Optional<Double> getHeatingSetPointCelsius() {
        return this.heatingSetPointCelsius;
    }

    @JsonProperty(value="heating_set_point_fahrenheit")
    public Optional<Double> getHeatingSetPointFahrenheit() {
        return this.heatingSetPointFahrenheit;
    }

    @JsonProperty(value="sync")
    public Optional<Boolean> getSync() {
        return this.sync;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ThermostatsHeatRequest && this.equalTo((ThermostatsHeatRequest)other);
    }

    private boolean equalTo(ThermostatsHeatRequest other) {
        return this.deviceId.equals(other.deviceId) && this.heatingSetPointCelsius.equals(other.heatingSetPointCelsius) && this.heatingSetPointFahrenheit.equals(other.heatingSetPointFahrenheit) && this.sync.equals(other.sync);
    }

    public int hashCode() {
        return Objects.hash(this.deviceId, this.heatingSetPointCelsius, this.heatingSetPointFahrenheit, this.sync);
    }

    public String toString() {
        return "ThermostatsHeatRequest{deviceId: " + this.deviceId + ", heatingSetPointCelsius: " + this.heatingSetPointCelsius + ", heatingSetPointFahrenheit: " + this.heatingSetPointFahrenheit + ", sync: " + this.sync + "}";
    }

    public static DeviceIdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements DeviceIdStage,
    _FinalStage {
        private String deviceId;
        private Optional<Boolean> sync = Optional.empty();
        private Optional<Double> heatingSetPointFahrenheit = Optional.empty();
        private Optional<Double> heatingSetPointCelsius = Optional.empty();

        private Builder() {
        }

        @Override
        public Builder from(ThermostatsHeatRequest other) {
            this.deviceId(other.getDeviceId());
            this.heatingSetPointCelsius(other.getHeatingSetPointCelsius());
            this.heatingSetPointFahrenheit(other.getHeatingSetPointFahrenheit());
            this.sync(other.getSync());
            return this;
        }

        @Override
        @JsonSetter(value="device_id")
        public _FinalStage deviceId(String deviceId) {
            this.deviceId = deviceId;
            return this;
        }

        @Override
        public _FinalStage sync(Boolean sync) {
            this.sync = Optional.of(sync);
            return this;
        }

        @Override
        @JsonSetter(value="sync", nulls=Nulls.SKIP)
        public _FinalStage sync(Optional<Boolean> sync) {
            this.sync = sync;
            return this;
        }

        @Override
        public _FinalStage heatingSetPointFahrenheit(Double heatingSetPointFahrenheit) {
            this.heatingSetPointFahrenheit = Optional.of(heatingSetPointFahrenheit);
            return this;
        }

        @Override
        @JsonSetter(value="heating_set_point_fahrenheit", nulls=Nulls.SKIP)
        public _FinalStage heatingSetPointFahrenheit(Optional<Double> heatingSetPointFahrenheit) {
            this.heatingSetPointFahrenheit = heatingSetPointFahrenheit;
            return this;
        }

        @Override
        public _FinalStage heatingSetPointCelsius(Double heatingSetPointCelsius) {
            this.heatingSetPointCelsius = Optional.of(heatingSetPointCelsius);
            return this;
        }

        @Override
        @JsonSetter(value="heating_set_point_celsius", nulls=Nulls.SKIP)
        public _FinalStage heatingSetPointCelsius(Optional<Double> heatingSetPointCelsius) {
            this.heatingSetPointCelsius = heatingSetPointCelsius;
            return this;
        }

        @Override
        public ThermostatsHeatRequest build() {
            return new ThermostatsHeatRequest(this.deviceId, this.heatingSetPointCelsius, this.heatingSetPointFahrenheit, this.sync);
        }
    }

    public static interface _FinalStage {
        public ThermostatsHeatRequest build();

        public _FinalStage heatingSetPointCelsius(Optional<Double> var1);

        public _FinalStage heatingSetPointCelsius(Double var1);

        public _FinalStage heatingSetPointFahrenheit(Optional<Double> var1);

        public _FinalStage heatingSetPointFahrenheit(Double var1);

        public _FinalStage sync(Optional<Boolean> var1);

        public _FinalStage sync(Boolean var1);
    }

    public static interface DeviceIdStage {
        public _FinalStage deviceId(String var1);

        public Builder from(ThermostatsHeatRequest var1);
    }
}

