/*
 * Decompiled with CFR 0.152.
 */
package com.seam.api.resources.thermostats.requests;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.seam.api.types.ThermostatsUpdateRequestDefaultClimateSetting;
import java.util.Objects;

@JsonDeserialize(builder=Builder.class)
public final class ThermostatsUpdateRequest {
    private final String deviceId;
    private final ThermostatsUpdateRequestDefaultClimateSetting defaultClimateSetting;

    private ThermostatsUpdateRequest(String deviceId, ThermostatsUpdateRequestDefaultClimateSetting defaultClimateSetting) {
        this.deviceId = deviceId;
        this.defaultClimateSetting = defaultClimateSetting;
    }

    @JsonProperty(value="device_id")
    public String getDeviceId() {
        return this.deviceId;
    }

    @JsonProperty(value="default_climate_setting")
    public ThermostatsUpdateRequestDefaultClimateSetting getDefaultClimateSetting() {
        return this.defaultClimateSetting;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ThermostatsUpdateRequest && this.equalTo((ThermostatsUpdateRequest)other);
    }

    private boolean equalTo(ThermostatsUpdateRequest other) {
        return this.deviceId.equals(other.deviceId) && this.defaultClimateSetting.equals(other.defaultClimateSetting);
    }

    public int hashCode() {
        return Objects.hash(this.deviceId, this.defaultClimateSetting);
    }

    public String toString() {
        return "ThermostatsUpdateRequest{deviceId: " + this.deviceId + ", defaultClimateSetting: " + this.defaultClimateSetting + "}";
    }

    public static DeviceIdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements DeviceIdStage,
    DefaultClimateSettingStage,
    _FinalStage {
        private String deviceId;
        private ThermostatsUpdateRequestDefaultClimateSetting defaultClimateSetting;

        private Builder() {
        }

        @Override
        public Builder from(ThermostatsUpdateRequest other) {
            this.deviceId(other.getDeviceId());
            this.defaultClimateSetting(other.getDefaultClimateSetting());
            return this;
        }

        @Override
        @JsonSetter(value="device_id")
        public DefaultClimateSettingStage deviceId(String deviceId) {
            this.deviceId = deviceId;
            return this;
        }

        @Override
        @JsonSetter(value="default_climate_setting")
        public _FinalStage defaultClimateSetting(ThermostatsUpdateRequestDefaultClimateSetting defaultClimateSetting) {
            this.defaultClimateSetting = defaultClimateSetting;
            return this;
        }

        @Override
        public ThermostatsUpdateRequest build() {
            return new ThermostatsUpdateRequest(this.deviceId, this.defaultClimateSetting);
        }
    }

    public static interface _FinalStage {
        public ThermostatsUpdateRequest build();
    }

    public static interface DefaultClimateSettingStage {
        public _FinalStage defaultClimateSetting(ThermostatsUpdateRequestDefaultClimateSetting var1);
    }

    public static interface DeviceIdStage {
        public DefaultClimateSettingStage deviceId(String var1);

        public Builder from(ThermostatsUpdateRequest var1);
    }
}

