/*
 * Decompiled with CFR 0.152.
 */
package com.seam.api.types;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.seam.api.types.Event;
import java.util.Objects;
import java.util.Optional;

@JsonDeserialize(builder=Builder.class)
public final class EventsGetResponse {
    private final Optional<Event> event;
    private final Optional<String> message;
    private final boolean ok;

    private EventsGetResponse(Optional<Event> event, Optional<String> message, boolean ok) {
        this.event = event;
        this.message = message;
        this.ok = ok;
    }

    @JsonProperty(value="event")
    public Optional<Event> getEvent() {
        return this.event;
    }

    @JsonProperty(value="message")
    public Optional<String> getMessage() {
        return this.message;
    }

    @JsonProperty(value="ok")
    public boolean getOk() {
        return this.ok;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof EventsGetResponse && this.equalTo((EventsGetResponse)other);
    }

    private boolean equalTo(EventsGetResponse other) {
        return this.event.equals(other.event) && this.message.equals(other.message) && this.ok == other.ok;
    }

    public int hashCode() {
        return Objects.hash(this.event, this.message, this.ok);
    }

    public String toString() {
        return "EventsGetResponse{event: " + this.event + ", message: " + this.message + ", ok: " + this.ok + "}";
    }

    public static OkStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements OkStage,
    _FinalStage {
        private boolean ok;
        private Optional<String> message = Optional.empty();
        private Optional<Event> event = Optional.empty();

        private Builder() {
        }

        @Override
        public Builder from(EventsGetResponse other) {
            this.event(other.getEvent());
            this.message(other.getMessage());
            this.ok(other.getOk());
            return this;
        }

        @Override
        @JsonSetter(value="ok")
        public _FinalStage ok(boolean ok) {
            this.ok = ok;
            return this;
        }

        @Override
        public _FinalStage message(String message) {
            this.message = Optional.of(message);
            return this;
        }

        @Override
        @JsonSetter(value="message", nulls=Nulls.SKIP)
        public _FinalStage message(Optional<String> message) {
            this.message = message;
            return this;
        }

        @Override
        public _FinalStage event(Event event) {
            this.event = Optional.of(event);
            return this;
        }

        @Override
        @JsonSetter(value="event", nulls=Nulls.SKIP)
        public _FinalStage event(Optional<Event> event) {
            this.event = event;
            return this;
        }

        @Override
        public EventsGetResponse build() {
            return new EventsGetResponse(this.event, this.message, this.ok);
        }
    }

    public static interface _FinalStage {
        public EventsGetResponse build();

        public _FinalStage event(Optional<Event> var1);

        public _FinalStage event(Event var1);

        public _FinalStage message(Optional<String> var1);

        public _FinalStage message(String var1);
    }

    public static interface OkStage {
        public _FinalStage ok(boolean var1);

        public Builder from(EventsGetResponse var1);
    }
}

