/*
 * Decompiled with CFR 0.152.
 */
package com.seam.api.types;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Objects;
import java.util.Optional;

@JsonDeserialize(builder=Builder.class)
public final class Workspace {
    private final String workspaceId;
    private final String name;
    private final boolean isSandbox;
    private final Optional<String> connectPartnerName;

    private Workspace(String workspaceId, String name, boolean isSandbox, Optional<String> connectPartnerName) {
        this.workspaceId = workspaceId;
        this.name = name;
        this.isSandbox = isSandbox;
        this.connectPartnerName = connectPartnerName;
    }

    @JsonProperty(value="workspace_id")
    public String getWorkspaceId() {
        return this.workspaceId;
    }

    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="is_sandbox")
    public boolean getIsSandbox() {
        return this.isSandbox;
    }

    @JsonProperty(value="connect_partner_name")
    public Optional<String> getConnectPartnerName() {
        return this.connectPartnerName;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof Workspace && this.equalTo((Workspace)other);
    }

    private boolean equalTo(Workspace other) {
        return this.workspaceId.equals(other.workspaceId) && this.name.equals(other.name) && this.isSandbox == other.isSandbox && this.connectPartnerName.equals(other.connectPartnerName);
    }

    public int hashCode() {
        return Objects.hash(this.workspaceId, this.name, this.isSandbox, this.connectPartnerName);
    }

    public String toString() {
        return "Workspace{workspaceId: " + this.workspaceId + ", name: " + this.name + ", isSandbox: " + this.isSandbox + ", connectPartnerName: " + this.connectPartnerName + "}";
    }

    public static WorkspaceIdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements WorkspaceIdStage,
    NameStage,
    IsSandboxStage,
    _FinalStage {
        private String workspaceId;
        private String name;
        private boolean isSandbox;
        private Optional<String> connectPartnerName = Optional.empty();

        private Builder() {
        }

        @Override
        public Builder from(Workspace other) {
            this.workspaceId(other.getWorkspaceId());
            this.name(other.getName());
            this.isSandbox(other.getIsSandbox());
            this.connectPartnerName(other.getConnectPartnerName());
            return this;
        }

        @Override
        @JsonSetter(value="workspace_id")
        public NameStage workspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
            return this;
        }

        @Override
        @JsonSetter(value="name")
        public IsSandboxStage name(String name) {
            this.name = name;
            return this;
        }

        @Override
        @JsonSetter(value="is_sandbox")
        public _FinalStage isSandbox(boolean isSandbox) {
            this.isSandbox = isSandbox;
            return this;
        }

        @Override
        public _FinalStage connectPartnerName(String connectPartnerName) {
            this.connectPartnerName = Optional.of(connectPartnerName);
            return this;
        }

        @Override
        @JsonSetter(value="connect_partner_name", nulls=Nulls.SKIP)
        public _FinalStage connectPartnerName(Optional<String> connectPartnerName) {
            this.connectPartnerName = connectPartnerName;
            return this;
        }

        @Override
        public Workspace build() {
            return new Workspace(this.workspaceId, this.name, this.isSandbox, this.connectPartnerName);
        }
    }

    public static interface _FinalStage {
        public Workspace build();

        public _FinalStage connectPartnerName(Optional<String> var1);

        public _FinalStage connectPartnerName(String var1);
    }

    public static interface IsSandboxStage {
        public _FinalStage isSandbox(boolean var1);
    }

    public static interface NameStage {
        public IsSandboxStage name(String var1);
    }

    public static interface WorkspaceIdStage {
        public NameStage workspaceId(String var1);

        public Builder from(Workspace var1);
    }
}

