/*
 * Decompiled with CFR 0.152.
 */
package com.seam.api.resources.accesscodes.unmanaged.requests;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class AccessCodesUnmanagedUpdateRequest {
    private final String accessCodeId;
    private final boolean isManaged;
    private final Optional<Boolean> force;

    private AccessCodesUnmanagedUpdateRequest(String accessCodeId, boolean isManaged, Optional<Boolean> force) {
        this.accessCodeId = accessCodeId;
        this.isManaged = isManaged;
        this.force = force;
    }

    @JsonProperty(value="access_code_id")
    public String getAccessCodeId() {
        return this.accessCodeId;
    }

    @JsonProperty(value="is_managed")
    public boolean getIsManaged() {
        return this.isManaged;
    }

    @JsonProperty(value="force")
    public Optional<Boolean> getForce() {
        return this.force;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof AccessCodesUnmanagedUpdateRequest && this.equalTo((AccessCodesUnmanagedUpdateRequest)other);
    }

    private boolean equalTo(AccessCodesUnmanagedUpdateRequest other) {
        return this.accessCodeId.equals(other.accessCodeId) && this.isManaged == other.isManaged && this.force.equals(other.force);
    }

    public int hashCode() {
        return Objects.hash(this.accessCodeId, this.isManaged, this.force);
    }

    public String toString() {
        return "AccessCodesUnmanagedUpdateRequest{accessCodeId: " + this.accessCodeId + ", isManaged: " + this.isManaged + ", force: " + this.force + "}";
    }

    public static AccessCodeIdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements AccessCodeIdStage,
    IsManagedStage,
    _FinalStage {
        private String accessCodeId;
        private boolean isManaged;
        private Optional<Boolean> force = Optional.empty();

        private Builder() {
        }

        @Override
        public Builder from(AccessCodesUnmanagedUpdateRequest other) {
            this.accessCodeId(other.getAccessCodeId());
            this.isManaged(other.getIsManaged());
            this.force(other.getForce());
            return this;
        }

        @Override
        @JsonSetter(value="access_code_id")
        public IsManagedStage accessCodeId(String accessCodeId) {
            this.accessCodeId = accessCodeId;
            return this;
        }

        @Override
        @JsonSetter(value="is_managed")
        public _FinalStage isManaged(boolean isManaged) {
            this.isManaged = isManaged;
            return this;
        }

        @Override
        public _FinalStage force(Boolean force) {
            this.force = Optional.of(force);
            return this;
        }

        @Override
        @JsonSetter(value="force", nulls=Nulls.SKIP)
        public _FinalStage force(Optional<Boolean> force) {
            this.force = force;
            return this;
        }

        @Override
        public AccessCodesUnmanagedUpdateRequest build() {
            return new AccessCodesUnmanagedUpdateRequest(this.accessCodeId, this.isManaged, this.force);
        }
    }

    public static interface _FinalStage {
        public AccessCodesUnmanagedUpdateRequest build();

        public _FinalStage force(Optional<Boolean> var1);

        public _FinalStage force(Boolean var1);
    }

    public static interface IsManagedStage {
        public _FinalStage isManaged(boolean var1);
    }

    public static interface AccessCodeIdStage {
        public IsManagedStage accessCodeId(String var1);

        public Builder from(AccessCodesUnmanagedUpdateRequest var1);
    }
}

