/*
 * Decompiled with CFR 0.152.
 */
package com.seam.api.resources.thermostats.climatesettingschedules;

import com.seam.api.core.ClientOptions;
import com.seam.api.core.ObjectMappers;
import com.seam.api.core.RequestOptions;
import com.seam.api.resources.thermostats.climatesettingschedules.requests.ThermostatsClimateSettingSchedulesCreateRequest;
import com.seam.api.resources.thermostats.climatesettingschedules.requests.ThermostatsClimateSettingSchedulesDeleteRequest;
import com.seam.api.resources.thermostats.climatesettingschedules.requests.ThermostatsClimateSettingSchedulesGetRequest;
import com.seam.api.resources.thermostats.climatesettingschedules.requests.ThermostatsClimateSettingSchedulesListRequest;
import com.seam.api.resources.thermostats.climatesettingschedules.requests.ThermostatsClimateSettingSchedulesUpdateRequest;
import com.seam.api.types.ThermostatsClimateSettingSchedulesCreateResponse;
import com.seam.api.types.ThermostatsClimateSettingSchedulesDeleteResponse;
import com.seam.api.types.ThermostatsClimateSettingSchedulesGetResponse;
import com.seam.api.types.ThermostatsClimateSettingSchedulesListResponse;
import com.seam.api.types.ThermostatsClimateSettingSchedulesUpdateResponse;
import java.util.HashMap;
import java.util.Optional;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class ClimateSettingSchedulesClient {
    protected final ClientOptions clientOptions;

    public ClimateSettingSchedulesClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
    }

    public ThermostatsClimateSettingSchedulesCreateResponse create(ThermostatsClimateSettingSchedulesCreateRequest request) {
        return this.create(request, null);
    }

    public ThermostatsClimateSettingSchedulesCreateResponse create(ThermostatsClimateSettingSchedulesCreateRequest request, RequestOptions requestOptions) {
        RequestBody _requestBody;
        HttpUrl _httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("thermostats/climate_setting_schedules/create").build();
        HashMap<String, Object> _requestBodyProperties = new HashMap<String, Object>();
        if (request.getScheduleType().isPresent()) {
            _requestBodyProperties.put("schedule_type", request.getScheduleType());
        }
        _requestBodyProperties.put("device_id", request.getDeviceId());
        if (request.getName().isPresent()) {
            _requestBodyProperties.put("name", request.getName());
        }
        _requestBodyProperties.put("schedule_starts_at", request.getScheduleStartsAt());
        _requestBodyProperties.put("schedule_ends_at", request.getScheduleEndsAt());
        if (request.getAutomaticHeatingEnabled().isPresent()) {
            _requestBodyProperties.put("automatic_heating_enabled", request.getAutomaticHeatingEnabled());
        }
        if (request.getAutomaticCoolingEnabled().isPresent()) {
            _requestBodyProperties.put("automatic_cooling_enabled", request.getAutomaticCoolingEnabled());
        }
        if (request.getHvacModeSetting().isPresent()) {
            _requestBodyProperties.put("hvac_mode_setting", request.getHvacModeSetting());
        }
        if (request.getCoolingSetPointCelsius().isPresent()) {
            _requestBodyProperties.put("cooling_set_point_celsius", request.getCoolingSetPointCelsius());
        }
        if (request.getHeatingSetPointCelsius().isPresent()) {
            _requestBodyProperties.put("heating_set_point_celsius", request.getHeatingSetPointCelsius());
        }
        if (request.getCoolingSetPointFahrenheit().isPresent()) {
            _requestBodyProperties.put("cooling_set_point_fahrenheit", request.getCoolingSetPointFahrenheit());
        }
        if (request.getHeatingSetPointFahrenheit().isPresent()) {
            _requestBodyProperties.put("heating_set_point_fahrenheit", request.getHeatingSetPointFahrenheit());
        }
        if (request.getManualOverrideAllowed().isPresent()) {
            _requestBodyProperties.put("manual_override_allowed", request.getManualOverrideAllowed());
        }
        try {
            _requestBody = RequestBody.create((byte[])ObjectMappers.JSON_MAPPER.writeValueAsBytes(_requestBodyProperties), (MediaType)MediaType.parse((String)"application/json"));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        Request.Builder _requestBuilder = new Request.Builder().url(_httpUrl).method("POST", _requestBody).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json");
        Request _request = _requestBuilder.build();
        try {
            Response _response = this.clientOptions.httpClient().newCall(_request).execute();
            if (_response.isSuccessful()) {
                return (ThermostatsClimateSettingSchedulesCreateResponse)ObjectMappers.JSON_MAPPER.readValue(_response.body().string(), ThermostatsClimateSettingSchedulesCreateResponse.class);
            }
            throw new RuntimeException();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public ThermostatsClimateSettingSchedulesDeleteResponse delete(ThermostatsClimateSettingSchedulesDeleteRequest request) {
        return this.delete(request, null);
    }

    public ThermostatsClimateSettingSchedulesDeleteResponse delete(ThermostatsClimateSettingSchedulesDeleteRequest request, RequestOptions requestOptions) {
        RequestBody _requestBody;
        HttpUrl _httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("thermostats/climate_setting_schedules/delete").build();
        HashMap<String, String> _requestBodyProperties = new HashMap<String, String>();
        _requestBodyProperties.put("climate_setting_schedule_id", request.getClimateSettingScheduleId());
        try {
            _requestBody = RequestBody.create((byte[])ObjectMappers.JSON_MAPPER.writeValueAsBytes(_requestBodyProperties), (MediaType)MediaType.parse((String)"application/json"));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        Request.Builder _requestBuilder = new Request.Builder().url(_httpUrl).method("POST", _requestBody).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json");
        Request _request = _requestBuilder.build();
        try {
            Response _response = this.clientOptions.httpClient().newCall(_request).execute();
            if (_response.isSuccessful()) {
                return (ThermostatsClimateSettingSchedulesDeleteResponse)ObjectMappers.JSON_MAPPER.readValue(_response.body().string(), ThermostatsClimateSettingSchedulesDeleteResponse.class);
            }
            throw new RuntimeException();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public ThermostatsClimateSettingSchedulesGetResponse get(ThermostatsClimateSettingSchedulesGetRequest request) {
        return this.get(request, null);
    }

    public ThermostatsClimateSettingSchedulesGetResponse get(ThermostatsClimateSettingSchedulesGetRequest request, RequestOptions requestOptions) {
        RequestBody _requestBody;
        HttpUrl _httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("thermostats/climate_setting_schedules/get").build();
        HashMap<String, Optional<String>> _requestBodyProperties = new HashMap<String, Optional<String>>();
        if (request.getClimateSettingScheduleId().isPresent()) {
            _requestBodyProperties.put("climate_setting_schedule_id", request.getClimateSettingScheduleId());
        }
        if (request.getDeviceId().isPresent()) {
            _requestBodyProperties.put("device_id", request.getDeviceId());
        }
        try {
            _requestBody = RequestBody.create((byte[])ObjectMappers.JSON_MAPPER.writeValueAsBytes(_requestBodyProperties), (MediaType)MediaType.parse((String)"application/json"));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        Request.Builder _requestBuilder = new Request.Builder().url(_httpUrl).method("POST", _requestBody).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json");
        Request _request = _requestBuilder.build();
        try {
            Response _response = this.clientOptions.httpClient().newCall(_request).execute();
            if (_response.isSuccessful()) {
                return (ThermostatsClimateSettingSchedulesGetResponse)ObjectMappers.JSON_MAPPER.readValue(_response.body().string(), ThermostatsClimateSettingSchedulesGetResponse.class);
            }
            throw new RuntimeException();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public ThermostatsClimateSettingSchedulesListResponse list(ThermostatsClimateSettingSchedulesListRequest request) {
        return this.list(request, null);
    }

    public ThermostatsClimateSettingSchedulesListResponse list(ThermostatsClimateSettingSchedulesListRequest request, RequestOptions requestOptions) {
        RequestBody _requestBody;
        HttpUrl _httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("thermostats/climate_setting_schedules/list").build();
        HashMap<String, String> _requestBodyProperties = new HashMap<String, String>();
        _requestBodyProperties.put("device_id", request.getDeviceId());
        try {
            _requestBody = RequestBody.create((byte[])ObjectMappers.JSON_MAPPER.writeValueAsBytes(_requestBodyProperties), (MediaType)MediaType.parse((String)"application/json"));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        Request.Builder _requestBuilder = new Request.Builder().url(_httpUrl).method("POST", _requestBody).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json");
        Request _request = _requestBuilder.build();
        try {
            Response _response = this.clientOptions.httpClient().newCall(_request).execute();
            if (_response.isSuccessful()) {
                return (ThermostatsClimateSettingSchedulesListResponse)ObjectMappers.JSON_MAPPER.readValue(_response.body().string(), ThermostatsClimateSettingSchedulesListResponse.class);
            }
            throw new RuntimeException();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public ThermostatsClimateSettingSchedulesUpdateResponse update(ThermostatsClimateSettingSchedulesUpdateRequest request) {
        return this.update(request, null);
    }

    public ThermostatsClimateSettingSchedulesUpdateResponse update(ThermostatsClimateSettingSchedulesUpdateRequest request, RequestOptions requestOptions) {
        RequestBody _requestBody;
        HttpUrl _httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("thermostats/climate_setting_schedules/update").build();
        HashMap<String, Object> _requestBodyProperties = new HashMap<String, Object>();
        _requestBodyProperties.put("climate_setting_schedule_id", request.getClimateSettingScheduleId());
        if (request.getScheduleType().isPresent()) {
            _requestBodyProperties.put("schedule_type", request.getScheduleType());
        }
        if (request.getName().isPresent()) {
            _requestBodyProperties.put("name", request.getName());
        }
        if (request.getScheduleStartsAt().isPresent()) {
            _requestBodyProperties.put("schedule_starts_at", request.getScheduleStartsAt());
        }
        if (request.getScheduleEndsAt().isPresent()) {
            _requestBodyProperties.put("schedule_ends_at", request.getScheduleEndsAt());
        }
        if (request.getAutomaticHeatingEnabled().isPresent()) {
            _requestBodyProperties.put("automatic_heating_enabled", request.getAutomaticHeatingEnabled());
        }
        if (request.getAutomaticCoolingEnabled().isPresent()) {
            _requestBodyProperties.put("automatic_cooling_enabled", request.getAutomaticCoolingEnabled());
        }
        if (request.getHvacModeSetting().isPresent()) {
            _requestBodyProperties.put("hvac_mode_setting", request.getHvacModeSetting());
        }
        if (request.getCoolingSetPointCelsius().isPresent()) {
            _requestBodyProperties.put("cooling_set_point_celsius", request.getCoolingSetPointCelsius());
        }
        if (request.getHeatingSetPointCelsius().isPresent()) {
            _requestBodyProperties.put("heating_set_point_celsius", request.getHeatingSetPointCelsius());
        }
        if (request.getCoolingSetPointFahrenheit().isPresent()) {
            _requestBodyProperties.put("cooling_set_point_fahrenheit", request.getCoolingSetPointFahrenheit());
        }
        if (request.getHeatingSetPointFahrenheit().isPresent()) {
            _requestBodyProperties.put("heating_set_point_fahrenheit", request.getHeatingSetPointFahrenheit());
        }
        if (request.getManualOverrideAllowed().isPresent()) {
            _requestBodyProperties.put("manual_override_allowed", request.getManualOverrideAllowed());
        }
        try {
            _requestBody = RequestBody.create((byte[])ObjectMappers.JSON_MAPPER.writeValueAsBytes(_requestBodyProperties), (MediaType)MediaType.parse((String)"application/json"));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        Request.Builder _requestBuilder = new Request.Builder().url(_httpUrl).method("POST", _requestBody).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json");
        Request _request = _requestBuilder.build();
        try {
            Response _response = this.clientOptions.httpClient().newCall(_request).execute();
            if (_response.isSuccessful()) {
                return (ThermostatsClimateSettingSchedulesUpdateResponse)ObjectMappers.JSON_MAPPER.readValue(_response.body().string(), ThermostatsClimateSettingSchedulesUpdateResponse.class);
            }
            throw new RuntimeException();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

