/*
 * Decompiled with CFR 0.152.
 */
package com.seam.api.types;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.seam.api.types.ServiceHealth;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class HealthServiceByServiceNameResponse {
    private final boolean ok;
    private final String lastServiceEvaluationAt;
    private final ServiceHealth serviceHealth;

    private HealthServiceByServiceNameResponse(boolean ok, String lastServiceEvaluationAt, ServiceHealth serviceHealth) {
        this.ok = ok;
        this.lastServiceEvaluationAt = lastServiceEvaluationAt;
        this.serviceHealth = serviceHealth;
    }

    @JsonProperty(value="ok")
    public boolean getOk() {
        return this.ok;
    }

    @JsonProperty(value="last_service_evaluation_at")
    public String getLastServiceEvaluationAt() {
        return this.lastServiceEvaluationAt;
    }

    @JsonProperty(value="service_health")
    public ServiceHealth getServiceHealth() {
        return this.serviceHealth;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof HealthServiceByServiceNameResponse && this.equalTo((HealthServiceByServiceNameResponse)other);
    }

    private boolean equalTo(HealthServiceByServiceNameResponse other) {
        return this.ok == other.ok && this.lastServiceEvaluationAt.equals(other.lastServiceEvaluationAt) && this.serviceHealth.equals(other.serviceHealth);
    }

    public int hashCode() {
        return Objects.hash(this.ok, this.lastServiceEvaluationAt, this.serviceHealth);
    }

    public String toString() {
        return "HealthServiceByServiceNameResponse{ok: " + this.ok + ", lastServiceEvaluationAt: " + this.lastServiceEvaluationAt + ", serviceHealth: " + this.serviceHealth + "}";
    }

    public static OkStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements OkStage,
    LastServiceEvaluationAtStage,
    ServiceHealthStage,
    _FinalStage {
        private boolean ok;
        private String lastServiceEvaluationAt;
        private ServiceHealth serviceHealth;

        private Builder() {
        }

        @Override
        public Builder from(HealthServiceByServiceNameResponse other) {
            this.ok(other.getOk());
            this.lastServiceEvaluationAt(other.getLastServiceEvaluationAt());
            this.serviceHealth(other.getServiceHealth());
            return this;
        }

        @Override
        @JsonSetter(value="ok")
        public LastServiceEvaluationAtStage ok(boolean ok) {
            this.ok = ok;
            return this;
        }

        @Override
        @JsonSetter(value="last_service_evaluation_at")
        public ServiceHealthStage lastServiceEvaluationAt(String lastServiceEvaluationAt) {
            this.lastServiceEvaluationAt = lastServiceEvaluationAt;
            return this;
        }

        @Override
        @JsonSetter(value="service_health")
        public _FinalStage serviceHealth(ServiceHealth serviceHealth) {
            this.serviceHealth = serviceHealth;
            return this;
        }

        @Override
        public HealthServiceByServiceNameResponse build() {
            return new HealthServiceByServiceNameResponse(this.ok, this.lastServiceEvaluationAt, this.serviceHealth);
        }
    }

    public static interface _FinalStage {
        public HealthServiceByServiceNameResponse build();
    }

    public static interface ServiceHealthStage {
        public _FinalStage serviceHealth(ServiceHealth var1);
    }

    public static interface LastServiceEvaluationAtStage {
        public ServiceHealthStage lastServiceEvaluationAt(String var1);
    }

    public static interface OkStage {
        public LastServiceEvaluationAtStage ok(boolean var1);

        public Builder from(HealthServiceByServiceNameResponse var1);
    }
}

