/*
 * Decompiled with CFR 0.152.
 */
package com.seam.api.resources.noisesensors.noisethresholds.requests;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class NoiseThresholdsDeleteRequest {
    private final String noiseThresholdId;
    private final String deviceId;
    private final Optional<Boolean> sync;

    private NoiseThresholdsDeleteRequest(String noiseThresholdId, String deviceId, Optional<Boolean> sync) {
        this.noiseThresholdId = noiseThresholdId;
        this.deviceId = deviceId;
        this.sync = sync;
    }

    @JsonProperty(value="noise_threshold_id")
    public String getNoiseThresholdId() {
        return this.noiseThresholdId;
    }

    @JsonProperty(value="device_id")
    public String getDeviceId() {
        return this.deviceId;
    }

    @JsonProperty(value="sync")
    public Optional<Boolean> getSync() {
        return this.sync;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof NoiseThresholdsDeleteRequest && this.equalTo((NoiseThresholdsDeleteRequest)other);
    }

    private boolean equalTo(NoiseThresholdsDeleteRequest other) {
        return this.noiseThresholdId.equals(other.noiseThresholdId) && this.deviceId.equals(other.deviceId) && this.sync.equals(other.sync);
    }

    public int hashCode() {
        return Objects.hash(this.noiseThresholdId, this.deviceId, this.sync);
    }

    public String toString() {
        return "NoiseThresholdsDeleteRequest{noiseThresholdId: " + this.noiseThresholdId + ", deviceId: " + this.deviceId + ", sync: " + this.sync + "}";
    }

    public static NoiseThresholdIdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements NoiseThresholdIdStage,
    DeviceIdStage,
    _FinalStage {
        private String noiseThresholdId;
        private String deviceId;
        private Optional<Boolean> sync = Optional.empty();

        private Builder() {
        }

        @Override
        public Builder from(NoiseThresholdsDeleteRequest other) {
            this.noiseThresholdId(other.getNoiseThresholdId());
            this.deviceId(other.getDeviceId());
            this.sync(other.getSync());
            return this;
        }

        @Override
        @JsonSetter(value="noise_threshold_id")
        public DeviceIdStage noiseThresholdId(String noiseThresholdId) {
            this.noiseThresholdId = noiseThresholdId;
            return this;
        }

        @Override
        @JsonSetter(value="device_id")
        public _FinalStage deviceId(String deviceId) {
            this.deviceId = deviceId;
            return this;
        }

        @Override
        public _FinalStage sync(Boolean sync) {
            this.sync = Optional.of(sync);
            return this;
        }

        @Override
        @JsonSetter(value="sync", nulls=Nulls.SKIP)
        public _FinalStage sync(Optional<Boolean> sync) {
            this.sync = sync;
            return this;
        }

        @Override
        public NoiseThresholdsDeleteRequest build() {
            return new NoiseThresholdsDeleteRequest(this.noiseThresholdId, this.deviceId, this.sync);
        }
    }

    public static interface _FinalStage {
        public NoiseThresholdsDeleteRequest build();

        public _FinalStage sync(Optional<Boolean> var1);

        public _FinalStage sync(Boolean var1);
    }

    public static interface DeviceIdStage {
        public _FinalStage deviceId(String var1);
    }

    public static interface NoiseThresholdIdStage {
        public DeviceIdStage noiseThresholdId(String var1);

        public Builder from(NoiseThresholdsDeleteRequest var1);
    }
}

