/*
 * Decompiled with CFR 0.152.
 */
package com.seam.api.types;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.seam.api.core.ObjectMappers;
import com.seam.api.types.ClientSession;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class ClientSessionsListResponse {
    private final List<ClientSession> clientSessions;
    private final boolean ok;

    private ClientSessionsListResponse(List<ClientSession> clientSessions, boolean ok) {
        this.clientSessions = clientSessions;
        this.ok = ok;
    }

    @JsonProperty(value="client_sessions")
    public List<ClientSession> getClientSessions() {
        return this.clientSessions;
    }

    @JsonProperty(value="ok")
    public boolean getOk() {
        return this.ok;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ClientSessionsListResponse && this.equalTo((ClientSessionsListResponse)other);
    }

    private boolean equalTo(ClientSessionsListResponse other) {
        return this.clientSessions.equals(other.clientSessions) && this.ok == other.ok;
    }

    public int hashCode() {
        return Objects.hash(this.clientSessions, this.ok);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static OkStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements OkStage,
    _FinalStage {
        private boolean ok;
        private List<ClientSession> clientSessions = new ArrayList<ClientSession>();

        private Builder() {
        }

        @Override
        public Builder from(ClientSessionsListResponse other) {
            this.clientSessions(other.getClientSessions());
            this.ok(other.getOk());
            return this;
        }

        @Override
        @JsonSetter(value="ok")
        public _FinalStage ok(boolean ok) {
            this.ok = ok;
            return this;
        }

        @Override
        public _FinalStage addAllClientSessions(List<ClientSession> clientSessions) {
            this.clientSessions.addAll(clientSessions);
            return this;
        }

        @Override
        public _FinalStage addClientSessions(ClientSession clientSessions) {
            this.clientSessions.add(clientSessions);
            return this;
        }

        @Override
        @JsonSetter(value="client_sessions", nulls=Nulls.SKIP)
        public _FinalStage clientSessions(List<ClientSession> clientSessions) {
            this.clientSessions.clear();
            this.clientSessions.addAll(clientSessions);
            return this;
        }

        @Override
        public ClientSessionsListResponse build() {
            return new ClientSessionsListResponse(this.clientSessions, this.ok);
        }
    }

    public static interface _FinalStage {
        public ClientSessionsListResponse build();

        public _FinalStage clientSessions(List<ClientSession> var1);

        public _FinalStage addClientSessions(ClientSession var1);

        public _FinalStage addAllClientSessions(List<ClientSession> var1);
    }

    public static interface OkStage {
        public _FinalStage ok(boolean var1);

        public Builder from(ClientSessionsListResponse var1);
    }
}

