/*
 * Decompiled with CFR 0.152.
 */
package com.seam.api.types;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.seam.api.core.ObjectMappers;
import com.seam.api.types.AugustDeviceMetadata;
import com.seam.api.types.CurrentClimateSetting;
import com.seam.api.types.DevicePropertiesModel;
import com.seam.api.types.SchlageDeviceMetadata;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class DeviceProperties {
    private final boolean online;
    private final String name;
    private final DevicePropertiesModel model;
    private final Optional<AugustDeviceMetadata> augustMetadata;
    private final Optional<SchlageDeviceMetadata> schlageMetadata;
    private final Object smartthingsMetadata;
    private final Optional<CurrentClimateSetting> currentClimateSetting;

    private DeviceProperties(boolean online, String name, DevicePropertiesModel model, Optional<AugustDeviceMetadata> augustMetadata, Optional<SchlageDeviceMetadata> schlageMetadata, Object smartthingsMetadata, Optional<CurrentClimateSetting> currentClimateSetting) {
        this.online = online;
        this.name = name;
        this.model = model;
        this.augustMetadata = augustMetadata;
        this.schlageMetadata = schlageMetadata;
        this.smartthingsMetadata = smartthingsMetadata;
        this.currentClimateSetting = currentClimateSetting;
    }

    @JsonProperty(value="online")
    public boolean getOnline() {
        return this.online;
    }

    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="model")
    public DevicePropertiesModel getModel() {
        return this.model;
    }

    @JsonProperty(value="august_metadata")
    public Optional<AugustDeviceMetadata> getAugustMetadata() {
        return this.augustMetadata;
    }

    @JsonProperty(value="schlage_metadata")
    public Optional<SchlageDeviceMetadata> getSchlageMetadata() {
        return this.schlageMetadata;
    }

    @JsonProperty(value="smartthings_metadata")
    public Object getSmartthingsMetadata() {
        return this.smartthingsMetadata;
    }

    @JsonProperty(value="current_climate_setting")
    public Optional<CurrentClimateSetting> getCurrentClimateSetting() {
        return this.currentClimateSetting;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof DeviceProperties && this.equalTo((DeviceProperties)other);
    }

    private boolean equalTo(DeviceProperties other) {
        return this.online == other.online && this.name.equals(other.name) && this.model.equals(other.model) && this.augustMetadata.equals(other.augustMetadata) && this.schlageMetadata.equals(other.schlageMetadata) && this.smartthingsMetadata.equals(other.smartthingsMetadata) && this.currentClimateSetting.equals(other.currentClimateSetting);
    }

    public int hashCode() {
        return Objects.hash(this.online, this.name, this.model, this.augustMetadata, this.schlageMetadata, this.smartthingsMetadata, this.currentClimateSetting);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static OnlineStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements OnlineStage,
    NameStage,
    ModelStage,
    SmartthingsMetadataStage,
    _FinalStage {
        private boolean online;
        private String name;
        private DevicePropertiesModel model;
        private Object smartthingsMetadata;
        private Optional<CurrentClimateSetting> currentClimateSetting = Optional.empty();
        private Optional<SchlageDeviceMetadata> schlageMetadata = Optional.empty();
        private Optional<AugustDeviceMetadata> augustMetadata = Optional.empty();

        private Builder() {
        }

        @Override
        public Builder from(DeviceProperties other) {
            this.online(other.getOnline());
            this.name(other.getName());
            this.model(other.getModel());
            this.augustMetadata(other.getAugustMetadata());
            this.schlageMetadata(other.getSchlageMetadata());
            this.smartthingsMetadata(other.getSmartthingsMetadata());
            this.currentClimateSetting(other.getCurrentClimateSetting());
            return this;
        }

        @Override
        @JsonSetter(value="online")
        public NameStage online(boolean online) {
            this.online = online;
            return this;
        }

        @Override
        @JsonSetter(value="name")
        public ModelStage name(String name) {
            this.name = name;
            return this;
        }

        @Override
        @JsonSetter(value="model")
        public SmartthingsMetadataStage model(DevicePropertiesModel model) {
            this.model = model;
            return this;
        }

        @Override
        @JsonSetter(value="smartthings_metadata")
        public _FinalStage smartthingsMetadata(Object smartthingsMetadata) {
            this.smartthingsMetadata = smartthingsMetadata;
            return this;
        }

        @Override
        public _FinalStage currentClimateSetting(CurrentClimateSetting currentClimateSetting) {
            this.currentClimateSetting = Optional.of(currentClimateSetting);
            return this;
        }

        @Override
        @JsonSetter(value="current_climate_setting", nulls=Nulls.SKIP)
        public _FinalStage currentClimateSetting(Optional<CurrentClimateSetting> currentClimateSetting) {
            this.currentClimateSetting = currentClimateSetting;
            return this;
        }

        @Override
        public _FinalStage schlageMetadata(SchlageDeviceMetadata schlageMetadata) {
            this.schlageMetadata = Optional.of(schlageMetadata);
            return this;
        }

        @Override
        @JsonSetter(value="schlage_metadata", nulls=Nulls.SKIP)
        public _FinalStage schlageMetadata(Optional<SchlageDeviceMetadata> schlageMetadata) {
            this.schlageMetadata = schlageMetadata;
            return this;
        }

        @Override
        public _FinalStage augustMetadata(AugustDeviceMetadata augustMetadata) {
            this.augustMetadata = Optional.of(augustMetadata);
            return this;
        }

        @Override
        @JsonSetter(value="august_metadata", nulls=Nulls.SKIP)
        public _FinalStage augustMetadata(Optional<AugustDeviceMetadata> augustMetadata) {
            this.augustMetadata = augustMetadata;
            return this;
        }

        @Override
        public DeviceProperties build() {
            return new DeviceProperties(this.online, this.name, this.model, this.augustMetadata, this.schlageMetadata, this.smartthingsMetadata, this.currentClimateSetting);
        }
    }

    public static interface _FinalStage {
        public DeviceProperties build();

        public _FinalStage augustMetadata(Optional<AugustDeviceMetadata> var1);

        public _FinalStage augustMetadata(AugustDeviceMetadata var1);

        public _FinalStage schlageMetadata(Optional<SchlageDeviceMetadata> var1);

        public _FinalStage schlageMetadata(SchlageDeviceMetadata var1);

        public _FinalStage currentClimateSetting(Optional<CurrentClimateSetting> var1);

        public _FinalStage currentClimateSetting(CurrentClimateSetting var1);
    }

    public static interface SmartthingsMetadataStage {
        public _FinalStage smartthingsMetadata(Object var1);
    }

    public static interface ModelStage {
        public SmartthingsMetadataStage model(DevicePropertiesModel var1);
    }

    public static interface NameStage {
        public ModelStage name(String var1);
    }

    public static interface OnlineStage {
        public NameStage online(boolean var1);

        public Builder from(DeviceProperties var1);
    }
}

