/*
 * Decompiled with CFR 0.152.
 */
package com.seam.api.resources.clientsessions;

import com.seam.api.core.ClientOptions;
import com.seam.api.core.ObjectMappers;
import com.seam.api.core.RequestOptions;
import com.seam.api.resources.clientsessions.requests.ClientSessionsCreateRequest;
import com.seam.api.resources.clientsessions.requests.ClientSessionsDeleteRequest;
import com.seam.api.resources.clientsessions.requests.ClientSessionsGetRequest;
import com.seam.api.resources.clientsessions.requests.ClientSessionsListRequest;
import com.seam.api.types.ClientSessionsCreateResponse;
import com.seam.api.types.ClientSessionsDeleteResponse;
import com.seam.api.types.ClientSessionsGetResponse;
import com.seam.api.types.ClientSessionsListResponse;
import java.util.HashMap;
import java.util.Optional;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class ClientSessionsClient {
    protected final ClientOptions clientOptions;

    public ClientSessionsClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
    }

    public ClientSessionsCreateResponse create(ClientSessionsCreateRequest request) {
        return this.create(request, null);
    }

    public ClientSessionsCreateResponse create(ClientSessionsCreateRequest request, RequestOptions requestOptions) {
        RequestBody _requestBody;
        HttpUrl _httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("client_sessions/create").build();
        HashMap<String, Optional<Object>> _requestBodyProperties = new HashMap<String, Optional<Object>>();
        if (request.getUserIdentifierKey().isPresent()) {
            _requestBodyProperties.put("user_identifier_key", request.getUserIdentifierKey());
        }
        if (request.getConnectWebviewIds().isPresent()) {
            _requestBodyProperties.put("connect_webview_ids", request.getConnectWebviewIds());
        }
        if (request.getConnectedAccountIds().isPresent()) {
            _requestBodyProperties.put("connected_account_ids", request.getConnectedAccountIds());
        }
        try {
            _requestBody = RequestBody.create((byte[])ObjectMappers.JSON_MAPPER.writeValueAsBytes(_requestBodyProperties), (MediaType)MediaType.parse((String)"application/json"));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        Request.Builder _requestBuilder = new Request.Builder().url(_httpUrl).method("POST", _requestBody).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json");
        Request _request = _requestBuilder.build();
        try {
            Response _response = this.clientOptions.httpClient().newCall(_request).execute();
            if (_response.isSuccessful()) {
                return (ClientSessionsCreateResponse)ObjectMappers.JSON_MAPPER.readValue(_response.body().string(), ClientSessionsCreateResponse.class);
            }
            throw new RuntimeException();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public ClientSessionsDeleteResponse delete(ClientSessionsDeleteRequest request) {
        return this.delete(request, null);
    }

    public ClientSessionsDeleteResponse delete(ClientSessionsDeleteRequest request, RequestOptions requestOptions) {
        RequestBody _requestBody;
        HttpUrl _httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("client_sessions/delete").build();
        HashMap<String, String> _requestBodyProperties = new HashMap<String, String>();
        _requestBodyProperties.put("client_session_id", request.getClientSessionId());
        try {
            _requestBody = RequestBody.create((byte[])ObjectMappers.JSON_MAPPER.writeValueAsBytes(_requestBodyProperties), (MediaType)MediaType.parse((String)"application/json"));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        Request.Builder _requestBuilder = new Request.Builder().url(_httpUrl).method("POST", _requestBody).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json");
        Request _request = _requestBuilder.build();
        try {
            Response _response = this.clientOptions.httpClient().newCall(_request).execute();
            if (_response.isSuccessful()) {
                return (ClientSessionsDeleteResponse)ObjectMappers.JSON_MAPPER.readValue(_response.body().string(), ClientSessionsDeleteResponse.class);
            }
            throw new RuntimeException();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public ClientSessionsGetResponse get(ClientSessionsGetRequest request) {
        return this.get(request, null);
    }

    public ClientSessionsGetResponse get(ClientSessionsGetRequest request, RequestOptions requestOptions) {
        RequestBody _requestBody;
        HttpUrl _httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("client_sessions/get").build();
        HashMap<String, Optional<String>> _requestBodyProperties = new HashMap<String, Optional<String>>();
        if (request.getClientSessionId().isPresent()) {
            _requestBodyProperties.put("client_session_id", request.getClientSessionId());
        }
        if (request.getUserIdentifierKey().isPresent()) {
            _requestBodyProperties.put("user_identifier_key", request.getUserIdentifierKey());
        }
        try {
            _requestBody = RequestBody.create((byte[])ObjectMappers.JSON_MAPPER.writeValueAsBytes(_requestBodyProperties), (MediaType)MediaType.parse((String)"application/json"));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        Request.Builder _requestBuilder = new Request.Builder().url(_httpUrl).method("POST", _requestBody).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json");
        Request _request = _requestBuilder.build();
        try {
            Response _response = this.clientOptions.httpClient().newCall(_request).execute();
            if (_response.isSuccessful()) {
                return (ClientSessionsGetResponse)ObjectMappers.JSON_MAPPER.readValue(_response.body().string(), ClientSessionsGetResponse.class);
            }
            throw new RuntimeException();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public ClientSessionsListResponse list(ClientSessionsListRequest request) {
        return this.list(request, null);
    }

    public ClientSessionsListResponse list(ClientSessionsListRequest request, RequestOptions requestOptions) {
        RequestBody _requestBody;
        HttpUrl _httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("client_sessions/list").build();
        HashMap<String, Optional<Object>> _requestBodyProperties = new HashMap<String, Optional<Object>>();
        if (request.getClientSessionId().isPresent()) {
            _requestBodyProperties.put("client_session_id", request.getClientSessionId());
        }
        if (request.getUserIdentifierKey().isPresent()) {
            _requestBodyProperties.put("user_identifier_key", request.getUserIdentifierKey());
        }
        if (request.getWithoutUserIdentifierKey().isPresent()) {
            _requestBodyProperties.put("without_user_identifier_key", request.getWithoutUserIdentifierKey());
        }
        try {
            _requestBody = RequestBody.create((byte[])ObjectMappers.JSON_MAPPER.writeValueAsBytes(_requestBodyProperties), (MediaType)MediaType.parse((String)"application/json"));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        Request.Builder _requestBuilder = new Request.Builder().url(_httpUrl).method("POST", _requestBody).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json");
        Request _request = _requestBuilder.build();
        try {
            Response _response = this.clientOptions.httpClient().newCall(_request).execute();
            if (_response.isSuccessful()) {
                return (ClientSessionsListResponse)ObjectMappers.JSON_MAPPER.readValue(_response.body().string(), ClientSessionsListResponse.class);
            }
            throw new RuntimeException();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

