/*
 * Decompiled with CFR 0.152.
 */
package com.seam.api.resources.webhooks.requests;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class WebhooksCreateRequest {
    private final String url;
    private final Optional<List<String>> eventTypes;

    private WebhooksCreateRequest(String url, Optional<List<String>> eventTypes) {
        this.url = url;
        this.eventTypes = eventTypes;
    }

    @JsonProperty(value="url")
    public String getUrl() {
        return this.url;
    }

    @JsonProperty(value="event_types")
    public Optional<List<String>> getEventTypes() {
        return this.eventTypes;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof WebhooksCreateRequest && this.equalTo((WebhooksCreateRequest)other);
    }

    private boolean equalTo(WebhooksCreateRequest other) {
        return this.url.equals(other.url) && this.eventTypes.equals(other.eventTypes);
    }

    public int hashCode() {
        return Objects.hash(this.url, this.eventTypes);
    }

    public String toString() {
        return "WebhooksCreateRequest{url: " + this.url + ", eventTypes: " + this.eventTypes + "}";
    }

    public static UrlStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements UrlStage,
    _FinalStage {
        private String url;
        private Optional<List<String>> eventTypes = Optional.empty();

        private Builder() {
        }

        @Override
        public Builder from(WebhooksCreateRequest other) {
            this.url(other.getUrl());
            this.eventTypes(other.getEventTypes());
            return this;
        }

        @Override
        @JsonSetter(value="url")
        public _FinalStage url(String url) {
            this.url = url;
            return this;
        }

        @Override
        public _FinalStage eventTypes(List<String> eventTypes) {
            this.eventTypes = Optional.of(eventTypes);
            return this;
        }

        @Override
        @JsonSetter(value="event_types", nulls=Nulls.SKIP)
        public _FinalStage eventTypes(Optional<List<String>> eventTypes) {
            this.eventTypes = eventTypes;
            return this;
        }

        @Override
        public WebhooksCreateRequest build() {
            return new WebhooksCreateRequest(this.url, this.eventTypes);
        }
    }

    public static interface _FinalStage {
        public WebhooksCreateRequest build();

        public _FinalStage eventTypes(Optional<List<String>> var1);

        public _FinalStage eventTypes(List<String> var1);
    }

    public static interface UrlStage {
        public _FinalStage url(String var1);

        public Builder from(WebhooksCreateRequest var1);
    }
}

