/*
 * Decompiled with CFR 0.152.
 */
package com.seam.api.types;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.seam.api.types.AccessCodeStatus;
import com.seam.api.types.AccessCodeType;
import java.time.OffsetDateTime;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class AccessCode {
    private final Optional<String> commonCodeKey;
    private final Optional<Boolean> isScheduledOnDevice;
    private final AccessCodeType type;
    private final Optional<Boolean> isWaitingForCodeAssignment;
    private final String accessCodeId;
    private final String deviceId;
    private final Optional<String> name;
    private final Optional<String> code;
    private final OffsetDateTime createdAt;
    private final Optional<Object> errors;
    private final Optional<Object> warnings;
    private final String isManaged;
    private final Optional<OffsetDateTime> startsAt;
    private final Optional<OffsetDateTime> endsAt;
    private final AccessCodeStatus status;
    private final boolean isBackupAccessCodeAvailable;
    private final Optional<Boolean> isBackup;
    private final Optional<String> pulledBackupAccessCodeId;

    private AccessCode(Optional<String> commonCodeKey, Optional<Boolean> isScheduledOnDevice, AccessCodeType type, Optional<Boolean> isWaitingForCodeAssignment, String accessCodeId, String deviceId, Optional<String> name, Optional<String> code, OffsetDateTime createdAt, Optional<Object> errors, Optional<Object> warnings, String isManaged, Optional<OffsetDateTime> startsAt, Optional<OffsetDateTime> endsAt, AccessCodeStatus status, boolean isBackupAccessCodeAvailable, Optional<Boolean> isBackup, Optional<String> pulledBackupAccessCodeId) {
        this.commonCodeKey = commonCodeKey;
        this.isScheduledOnDevice = isScheduledOnDevice;
        this.type = type;
        this.isWaitingForCodeAssignment = isWaitingForCodeAssignment;
        this.accessCodeId = accessCodeId;
        this.deviceId = deviceId;
        this.name = name;
        this.code = code;
        this.createdAt = createdAt;
        this.errors = errors;
        this.warnings = warnings;
        this.isManaged = isManaged;
        this.startsAt = startsAt;
        this.endsAt = endsAt;
        this.status = status;
        this.isBackupAccessCodeAvailable = isBackupAccessCodeAvailable;
        this.isBackup = isBackup;
        this.pulledBackupAccessCodeId = pulledBackupAccessCodeId;
    }

    @JsonProperty(value="common_code_key")
    public Optional<String> getCommonCodeKey() {
        return this.commonCodeKey;
    }

    @JsonProperty(value="is_scheduled_on_device")
    public Optional<Boolean> getIsScheduledOnDevice() {
        return this.isScheduledOnDevice;
    }

    @JsonProperty(value="type")
    public AccessCodeType getType() {
        return this.type;
    }

    @JsonProperty(value="is_waiting_for_code_assignment")
    public Optional<Boolean> getIsWaitingForCodeAssignment() {
        return this.isWaitingForCodeAssignment;
    }

    @JsonProperty(value="access_code_id")
    public String getAccessCodeId() {
        return this.accessCodeId;
    }

    @JsonProperty(value="device_id")
    public String getDeviceId() {
        return this.deviceId;
    }

    @JsonProperty(value="name")
    public Optional<String> getName() {
        return this.name;
    }

    @JsonProperty(value="code")
    public Optional<String> getCode() {
        return this.code;
    }

    @JsonProperty(value="created_at")
    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="errors")
    public Optional<Object> getErrors() {
        return this.errors;
    }

    @JsonProperty(value="warnings")
    public Optional<Object> getWarnings() {
        return this.warnings;
    }

    @JsonProperty(value="is_managed")
    public String getIsManaged() {
        return this.isManaged;
    }

    @JsonProperty(value="starts_at")
    public Optional<OffsetDateTime> getStartsAt() {
        return this.startsAt;
    }

    @JsonProperty(value="ends_at")
    public Optional<OffsetDateTime> getEndsAt() {
        return this.endsAt;
    }

    @JsonProperty(value="status")
    public AccessCodeStatus getStatus() {
        return this.status;
    }

    @JsonProperty(value="is_backup_access_code_available")
    public boolean getIsBackupAccessCodeAvailable() {
        return this.isBackupAccessCodeAvailable;
    }

    @JsonProperty(value="is_backup")
    public Optional<Boolean> getIsBackup() {
        return this.isBackup;
    }

    @JsonProperty(value="pulled_backup_access_code_id")
    public Optional<String> getPulledBackupAccessCodeId() {
        return this.pulledBackupAccessCodeId;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof AccessCode && this.equalTo((AccessCode)other);
    }

    private boolean equalTo(AccessCode other) {
        return this.commonCodeKey.equals(other.commonCodeKey) && this.isScheduledOnDevice.equals(other.isScheduledOnDevice) && this.type.equals((Object)other.type) && this.isWaitingForCodeAssignment.equals(other.isWaitingForCodeAssignment) && this.accessCodeId.equals(other.accessCodeId) && this.deviceId.equals(other.deviceId) && this.name.equals(other.name) && this.code.equals(other.code) && this.createdAt.equals(other.createdAt) && this.errors.equals(other.errors) && this.warnings.equals(other.warnings) && this.isManaged.equals(other.isManaged) && this.startsAt.equals(other.startsAt) && this.endsAt.equals(other.endsAt) && this.status.equals((Object)other.status) && this.isBackupAccessCodeAvailable == other.isBackupAccessCodeAvailable && this.isBackup.equals(other.isBackup) && this.pulledBackupAccessCodeId.equals(other.pulledBackupAccessCodeId);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.commonCodeKey, this.isScheduledOnDevice, this.type, this.isWaitingForCodeAssignment, this.accessCodeId, this.deviceId, this.name, this.code, this.createdAt, this.errors, this.warnings, this.isManaged, this.startsAt, this.endsAt, this.status, this.isBackupAccessCodeAvailable, this.isBackup, this.pulledBackupAccessCodeId});
    }

    public String toString() {
        return "AccessCode{commonCodeKey: " + this.commonCodeKey + ", isScheduledOnDevice: " + this.isScheduledOnDevice + ", type: " + this.type + ", isWaitingForCodeAssignment: " + this.isWaitingForCodeAssignment + ", accessCodeId: " + this.accessCodeId + ", deviceId: " + this.deviceId + ", name: " + this.name + ", code: " + this.code + ", createdAt: " + this.createdAt + ", errors: " + this.errors + ", warnings: " + this.warnings + ", isManaged: " + this.isManaged + ", startsAt: " + this.startsAt + ", endsAt: " + this.endsAt + ", status: " + this.status + ", isBackupAccessCodeAvailable: " + this.isBackupAccessCodeAvailable + ", isBackup: " + this.isBackup + ", pulledBackupAccessCodeId: " + this.pulledBackupAccessCodeId + "}";
    }

    public static TypeStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements TypeStage,
    AccessCodeIdStage,
    DeviceIdStage,
    CreatedAtStage,
    IsManagedStage,
    StatusStage,
    IsBackupAccessCodeAvailableStage,
    _FinalStage {
        private AccessCodeType type;
        private String accessCodeId;
        private String deviceId;
        private OffsetDateTime createdAt;
        private String isManaged;
        private AccessCodeStatus status;
        private boolean isBackupAccessCodeAvailable;
        private Optional<String> pulledBackupAccessCodeId = Optional.empty();
        private Optional<Boolean> isBackup = Optional.empty();
        private Optional<OffsetDateTime> endsAt = Optional.empty();
        private Optional<OffsetDateTime> startsAt = Optional.empty();
        private Optional<Object> warnings = Optional.empty();
        private Optional<Object> errors = Optional.empty();
        private Optional<String> code = Optional.empty();
        private Optional<String> name = Optional.empty();
        private Optional<Boolean> isWaitingForCodeAssignment = Optional.empty();
        private Optional<Boolean> isScheduledOnDevice = Optional.empty();
        private Optional<String> commonCodeKey = Optional.empty();

        private Builder() {
        }

        @Override
        public Builder from(AccessCode other) {
            this.commonCodeKey(other.getCommonCodeKey());
            this.isScheduledOnDevice(other.getIsScheduledOnDevice());
            this.type(other.getType());
            this.isWaitingForCodeAssignment(other.getIsWaitingForCodeAssignment());
            this.accessCodeId(other.getAccessCodeId());
            this.deviceId(other.getDeviceId());
            this.name(other.getName());
            this.code(other.getCode());
            this.createdAt(other.getCreatedAt());
            this.errors(other.getErrors());
            this.warnings(other.getWarnings());
            this.isManaged(other.getIsManaged());
            this.startsAt(other.getStartsAt());
            this.endsAt(other.getEndsAt());
            this.status(other.getStatus());
            this.isBackupAccessCodeAvailable(other.getIsBackupAccessCodeAvailable());
            this.isBackup(other.getIsBackup());
            this.pulledBackupAccessCodeId(other.getPulledBackupAccessCodeId());
            return this;
        }

        @Override
        @JsonSetter(value="type")
        public AccessCodeIdStage type(AccessCodeType type) {
            this.type = type;
            return this;
        }

        @Override
        @JsonSetter(value="access_code_id")
        public DeviceIdStage accessCodeId(String accessCodeId) {
            this.accessCodeId = accessCodeId;
            return this;
        }

        @Override
        @JsonSetter(value="device_id")
        public CreatedAtStage deviceId(String deviceId) {
            this.deviceId = deviceId;
            return this;
        }

        @Override
        @JsonSetter(value="created_at")
        public IsManagedStage createdAt(OffsetDateTime createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        @Override
        @JsonSetter(value="is_managed")
        public StatusStage isManaged(String isManaged) {
            this.isManaged = isManaged;
            return this;
        }

        @Override
        @JsonSetter(value="status")
        public IsBackupAccessCodeAvailableStage status(AccessCodeStatus status) {
            this.status = status;
            return this;
        }

        @Override
        @JsonSetter(value="is_backup_access_code_available")
        public _FinalStage isBackupAccessCodeAvailable(boolean isBackupAccessCodeAvailable) {
            this.isBackupAccessCodeAvailable = isBackupAccessCodeAvailable;
            return this;
        }

        @Override
        public _FinalStage pulledBackupAccessCodeId(String pulledBackupAccessCodeId) {
            this.pulledBackupAccessCodeId = Optional.of(pulledBackupAccessCodeId);
            return this;
        }

        @Override
        @JsonSetter(value="pulled_backup_access_code_id", nulls=Nulls.SKIP)
        public _FinalStage pulledBackupAccessCodeId(Optional<String> pulledBackupAccessCodeId) {
            this.pulledBackupAccessCodeId = pulledBackupAccessCodeId;
            return this;
        }

        @Override
        public _FinalStage isBackup(Boolean isBackup) {
            this.isBackup = Optional.of(isBackup);
            return this;
        }

        @Override
        @JsonSetter(value="is_backup", nulls=Nulls.SKIP)
        public _FinalStage isBackup(Optional<Boolean> isBackup) {
            this.isBackup = isBackup;
            return this;
        }

        @Override
        public _FinalStage endsAt(OffsetDateTime endsAt) {
            this.endsAt = Optional.of(endsAt);
            return this;
        }

        @Override
        @JsonSetter(value="ends_at", nulls=Nulls.SKIP)
        public _FinalStage endsAt(Optional<OffsetDateTime> endsAt) {
            this.endsAt = endsAt;
            return this;
        }

        @Override
        public _FinalStage startsAt(OffsetDateTime startsAt) {
            this.startsAt = Optional.of(startsAt);
            return this;
        }

        @Override
        @JsonSetter(value="starts_at", nulls=Nulls.SKIP)
        public _FinalStage startsAt(Optional<OffsetDateTime> startsAt) {
            this.startsAt = startsAt;
            return this;
        }

        @Override
        public _FinalStage warnings(Object warnings) {
            this.warnings = Optional.of(warnings);
            return this;
        }

        @Override
        @JsonSetter(value="warnings", nulls=Nulls.SKIP)
        public _FinalStage warnings(Optional<Object> warnings) {
            this.warnings = warnings;
            return this;
        }

        @Override
        public _FinalStage errors(Object errors) {
            this.errors = Optional.of(errors);
            return this;
        }

        @Override
        @JsonSetter(value="errors", nulls=Nulls.SKIP)
        public _FinalStage errors(Optional<Object> errors) {
            this.errors = errors;
            return this;
        }

        @Override
        public _FinalStage code(String code) {
            this.code = Optional.of(code);
            return this;
        }

        @Override
        @JsonSetter(value="code", nulls=Nulls.SKIP)
        public _FinalStage code(Optional<String> code) {
            this.code = code;
            return this;
        }

        @Override
        public _FinalStage name(String name) {
            this.name = Optional.of(name);
            return this;
        }

        @Override
        @JsonSetter(value="name", nulls=Nulls.SKIP)
        public _FinalStage name(Optional<String> name) {
            this.name = name;
            return this;
        }

        @Override
        public _FinalStage isWaitingForCodeAssignment(Boolean isWaitingForCodeAssignment) {
            this.isWaitingForCodeAssignment = Optional.of(isWaitingForCodeAssignment);
            return this;
        }

        @Override
        @JsonSetter(value="is_waiting_for_code_assignment", nulls=Nulls.SKIP)
        public _FinalStage isWaitingForCodeAssignment(Optional<Boolean> isWaitingForCodeAssignment) {
            this.isWaitingForCodeAssignment = isWaitingForCodeAssignment;
            return this;
        }

        @Override
        public _FinalStage isScheduledOnDevice(Boolean isScheduledOnDevice) {
            this.isScheduledOnDevice = Optional.of(isScheduledOnDevice);
            return this;
        }

        @Override
        @JsonSetter(value="is_scheduled_on_device", nulls=Nulls.SKIP)
        public _FinalStage isScheduledOnDevice(Optional<Boolean> isScheduledOnDevice) {
            this.isScheduledOnDevice = isScheduledOnDevice;
            return this;
        }

        @Override
        public _FinalStage commonCodeKey(String commonCodeKey) {
            this.commonCodeKey = Optional.of(commonCodeKey);
            return this;
        }

        @Override
        @JsonSetter(value="common_code_key", nulls=Nulls.SKIP)
        public _FinalStage commonCodeKey(Optional<String> commonCodeKey) {
            this.commonCodeKey = commonCodeKey;
            return this;
        }

        @Override
        public AccessCode build() {
            return new AccessCode(this.commonCodeKey, this.isScheduledOnDevice, this.type, this.isWaitingForCodeAssignment, this.accessCodeId, this.deviceId, this.name, this.code, this.createdAt, this.errors, this.warnings, this.isManaged, this.startsAt, this.endsAt, this.status, this.isBackupAccessCodeAvailable, this.isBackup, this.pulledBackupAccessCodeId);
        }
    }

    public static interface _FinalStage {
        public AccessCode build();

        public _FinalStage commonCodeKey(Optional<String> var1);

        public _FinalStage commonCodeKey(String var1);

        public _FinalStage isScheduledOnDevice(Optional<Boolean> var1);

        public _FinalStage isScheduledOnDevice(Boolean var1);

        public _FinalStage isWaitingForCodeAssignment(Optional<Boolean> var1);

        public _FinalStage isWaitingForCodeAssignment(Boolean var1);

        public _FinalStage name(Optional<String> var1);

        public _FinalStage name(String var1);

        public _FinalStage code(Optional<String> var1);

        public _FinalStage code(String var1);

        public _FinalStage errors(Optional<Object> var1);

        public _FinalStage errors(Object var1);

        public _FinalStage warnings(Optional<Object> var1);

        public _FinalStage warnings(Object var1);

        public _FinalStage startsAt(Optional<OffsetDateTime> var1);

        public _FinalStage startsAt(OffsetDateTime var1);

        public _FinalStage endsAt(Optional<OffsetDateTime> var1);

        public _FinalStage endsAt(OffsetDateTime var1);

        public _FinalStage isBackup(Optional<Boolean> var1);

        public _FinalStage isBackup(Boolean var1);

        public _FinalStage pulledBackupAccessCodeId(Optional<String> var1);

        public _FinalStage pulledBackupAccessCodeId(String var1);
    }

    public static interface IsBackupAccessCodeAvailableStage {
        public _FinalStage isBackupAccessCodeAvailable(boolean var1);
    }

    public static interface StatusStage {
        public IsBackupAccessCodeAvailableStage status(AccessCodeStatus var1);
    }

    public static interface IsManagedStage {
        public StatusStage isManaged(String var1);
    }

    public static interface CreatedAtStage {
        public IsManagedStage createdAt(OffsetDateTime var1);
    }

    public static interface DeviceIdStage {
        public CreatedAtStage deviceId(String var1);
    }

    public static interface AccessCodeIdStage {
        public DeviceIdStage accessCodeId(String var1);
    }

    public static interface TypeStage {
        public AccessCodeIdStage type(AccessCodeType var1);

        public Builder from(AccessCode var1);
    }
}

