/*
 * Decompiled with CFR 0.152.
 */
package com.seam.api.resources.devices;

import com.seam.api.core.ApiError;
import com.seam.api.core.ClientOptions;
import com.seam.api.core.ObjectMappers;
import com.seam.api.core.RequestOptions;
import com.seam.api.core.Suppliers;
import com.seam.api.resources.devices.requests.DevicesDeleteRequest;
import com.seam.api.resources.devices.requests.DevicesGetRequest;
import com.seam.api.resources.devices.requests.DevicesListDeviceProvidersRequest;
import com.seam.api.resources.devices.requests.DevicesListRequest;
import com.seam.api.resources.devices.requests.DevicesUpdateRequest;
import com.seam.api.resources.devices.unmanaged.UnmanagedClient;
import com.seam.api.types.Device;
import com.seam.api.types.DeviceListProvider;
import com.seam.api.types.DevicesDeleteResponse;
import com.seam.api.types.DevicesGetResponse;
import com.seam.api.types.DevicesListDeviceProvidersResponse;
import com.seam.api.types.DevicesListResponse;
import com.seam.api.types.DevicesUpdateResponse;
import java.io.IOException;
import java.util.List;
import java.util.function.Supplier;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class DevicesClient {
    protected final ClientOptions clientOptions;
    protected final Supplier<UnmanagedClient> unmanagedClient;

    public DevicesClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.unmanagedClient = Suppliers.memoize(() -> new UnmanagedClient(clientOptions));
    }

    public void delete(DevicesDeleteRequest request) {
        this.delete(request, null);
    }

    public void delete(DevicesDeleteRequest request, RequestOptions requestOptions) {
        RequestBody body;
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("devices/delete").build();
        try {
            body = RequestBody.create((byte[])ObjectMappers.JSON_MAPPER.writeValueAsBytes((Object)request), (MediaType)MediaType.parse((String)"application/json"));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("POST", body).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json").build();
        try {
            Response response = this.clientOptions.httpClient().newCall(okhttpRequest).execute();
            if (response.isSuccessful()) {
                ObjectMappers.JSON_MAPPER.readValue(response.body().string(), DevicesDeleteResponse.class);
                return;
            }
            throw new ApiError(response.code(), ObjectMappers.JSON_MAPPER.readValue(response.body().string(), Object.class));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public Device get(DevicesGetRequest request) {
        return this.get(request, null);
    }

    public Device get(DevicesGetRequest request, RequestOptions requestOptions) {
        RequestBody body;
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("devices/get").build();
        try {
            body = RequestBody.create((byte[])ObjectMappers.JSON_MAPPER.writeValueAsBytes((Object)request), (MediaType)MediaType.parse((String)"application/json"));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("POST", body).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json").build();
        try {
            Response response = this.clientOptions.httpClient().newCall(okhttpRequest).execute();
            if (response.isSuccessful()) {
                DevicesGetResponse parsedResponse = (DevicesGetResponse)ObjectMappers.JSON_MAPPER.readValue(response.body().string(), DevicesGetResponse.class);
                return parsedResponse.getDevice();
            }
            throw new ApiError(response.code(), ObjectMappers.JSON_MAPPER.readValue(response.body().string(), Object.class));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public Device get() {
        return this.get(DevicesGetRequest.builder().build());
    }

    public List<Device> list(DevicesListRequest request) {
        return this.list(request, null);
    }

    public List<Device> list(DevicesListRequest request, RequestOptions requestOptions) {
        RequestBody body;
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("devices/list").build();
        try {
            body = RequestBody.create((byte[])ObjectMappers.JSON_MAPPER.writeValueAsBytes((Object)request), (MediaType)MediaType.parse((String)"application/json"));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("POST", body).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json").build();
        try {
            Response response = this.clientOptions.httpClient().newCall(okhttpRequest).execute();
            if (response.isSuccessful()) {
                DevicesListResponse parsedResponse = (DevicesListResponse)ObjectMappers.JSON_MAPPER.readValue(response.body().string(), DevicesListResponse.class);
                return parsedResponse.getDevices();
            }
            throw new ApiError(response.code(), ObjectMappers.JSON_MAPPER.readValue(response.body().string(), Object.class));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public List<Device> list() {
        return this.list(DevicesListRequest.builder().build());
    }

    public List<DeviceListProvider> listDeviceProviders(DevicesListDeviceProvidersRequest request) {
        return this.listDeviceProviders(request, null);
    }

    public List<DeviceListProvider> listDeviceProviders(DevicesListDeviceProvidersRequest request, RequestOptions requestOptions) {
        RequestBody body;
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("devices/list_device_providers").build();
        try {
            body = RequestBody.create((byte[])ObjectMappers.JSON_MAPPER.writeValueAsBytes((Object)request), (MediaType)MediaType.parse((String)"application/json"));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("POST", body).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json").build();
        try {
            Response response = this.clientOptions.httpClient().newCall(okhttpRequest).execute();
            if (response.isSuccessful()) {
                DevicesListDeviceProvidersResponse parsedResponse = (DevicesListDeviceProvidersResponse)ObjectMappers.JSON_MAPPER.readValue(response.body().string(), DevicesListDeviceProvidersResponse.class);
                return parsedResponse.getDeviceProviders();
            }
            throw new ApiError(response.code(), ObjectMappers.JSON_MAPPER.readValue(response.body().string(), Object.class));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public List<DeviceListProvider> listDeviceProviders() {
        return this.listDeviceProviders(DevicesListDeviceProvidersRequest.builder().build());
    }

    public void update(DevicesUpdateRequest request) {
        this.update(request, null);
    }

    public void update(DevicesUpdateRequest request, RequestOptions requestOptions) {
        RequestBody body;
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("devices/update").build();
        try {
            body = RequestBody.create((byte[])ObjectMappers.JSON_MAPPER.writeValueAsBytes((Object)request), (MediaType)MediaType.parse((String)"application/json"));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("POST", body).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json").build();
        try {
            Response response = this.clientOptions.httpClient().newCall(okhttpRequest).execute();
            if (response.isSuccessful()) {
                ObjectMappers.JSON_MAPPER.readValue(response.body().string(), DevicesUpdateResponse.class);
                return;
            }
            throw new ApiError(response.code(), ObjectMappers.JSON_MAPPER.readValue(response.body().string(), Object.class));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public UnmanagedClient unmanaged() {
        return this.unmanagedClient.get();
    }
}

