/*
 * Decompiled with CFR 0.152.
 */
package com.seam.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.seam.api.core.ObjectMappers;
import com.seam.api.types.HvacModeSetting;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class ClimateSettingSchedule {
    private final String climateSettingScheduleId;
    private final String deviceId;
    private final Optional<String> name;
    private final String scheduleStartsAt;
    private final String scheduleEndsAt;
    private final OffsetDateTime createdAt;
    private final Optional<Boolean> automaticHeatingEnabled;
    private final Optional<Boolean> automaticCoolingEnabled;
    private final Optional<HvacModeSetting> hvacModeSetting;
    private final Optional<Double> coolingSetPointCelsius;
    private final Optional<Double> heatingSetPointCelsius;
    private final Optional<Double> coolingSetPointFahrenheit;
    private final Optional<Double> heatingSetPointFahrenheit;
    private final Optional<Boolean> manualOverrideAllowed;
    private final Map<String, Object> additionalProperties;

    private ClimateSettingSchedule(String climateSettingScheduleId, String deviceId, Optional<String> name, String scheduleStartsAt, String scheduleEndsAt, OffsetDateTime createdAt, Optional<Boolean> automaticHeatingEnabled, Optional<Boolean> automaticCoolingEnabled, Optional<HvacModeSetting> hvacModeSetting, Optional<Double> coolingSetPointCelsius, Optional<Double> heatingSetPointCelsius, Optional<Double> coolingSetPointFahrenheit, Optional<Double> heatingSetPointFahrenheit, Optional<Boolean> manualOverrideAllowed, Map<String, Object> additionalProperties) {
        this.climateSettingScheduleId = climateSettingScheduleId;
        this.deviceId = deviceId;
        this.name = name;
        this.scheduleStartsAt = scheduleStartsAt;
        this.scheduleEndsAt = scheduleEndsAt;
        this.createdAt = createdAt;
        this.automaticHeatingEnabled = automaticHeatingEnabled;
        this.automaticCoolingEnabled = automaticCoolingEnabled;
        this.hvacModeSetting = hvacModeSetting;
        this.coolingSetPointCelsius = coolingSetPointCelsius;
        this.heatingSetPointCelsius = heatingSetPointCelsius;
        this.coolingSetPointFahrenheit = coolingSetPointFahrenheit;
        this.heatingSetPointFahrenheit = heatingSetPointFahrenheit;
        this.manualOverrideAllowed = manualOverrideAllowed;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="climate_setting_schedule_id")
    public String getClimateSettingScheduleId() {
        return this.climateSettingScheduleId;
    }

    @JsonProperty(value="schedule_type")
    public String getScheduleType() {
        return "time_bound";
    }

    @JsonProperty(value="device_id")
    public String getDeviceId() {
        return this.deviceId;
    }

    @JsonProperty(value="name")
    public Optional<String> getName() {
        return this.name;
    }

    @JsonProperty(value="schedule_starts_at")
    public String getScheduleStartsAt() {
        return this.scheduleStartsAt;
    }

    @JsonProperty(value="schedule_ends_at")
    public String getScheduleEndsAt() {
        return this.scheduleEndsAt;
    }

    @JsonProperty(value="created_at")
    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="automatic_heating_enabled")
    public Optional<Boolean> getAutomaticHeatingEnabled() {
        return this.automaticHeatingEnabled;
    }

    @JsonProperty(value="automatic_cooling_enabled")
    public Optional<Boolean> getAutomaticCoolingEnabled() {
        return this.automaticCoolingEnabled;
    }

    @JsonProperty(value="hvac_mode_setting")
    public Optional<HvacModeSetting> getHvacModeSetting() {
        return this.hvacModeSetting;
    }

    @JsonProperty(value="cooling_set_point_celsius")
    public Optional<Double> getCoolingSetPointCelsius() {
        return this.coolingSetPointCelsius;
    }

    @JsonProperty(value="heating_set_point_celsius")
    public Optional<Double> getHeatingSetPointCelsius() {
        return this.heatingSetPointCelsius;
    }

    @JsonProperty(value="cooling_set_point_fahrenheit")
    public Optional<Double> getCoolingSetPointFahrenheit() {
        return this.coolingSetPointFahrenheit;
    }

    @JsonProperty(value="heating_set_point_fahrenheit")
    public Optional<Double> getHeatingSetPointFahrenheit() {
        return this.heatingSetPointFahrenheit;
    }

    @JsonProperty(value="manual_override_allowed")
    public Optional<Boolean> getManualOverrideAllowed() {
        return this.manualOverrideAllowed;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ClimateSettingSchedule && this.equalTo((ClimateSettingSchedule)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ClimateSettingSchedule other) {
        return this.climateSettingScheduleId.equals(other.climateSettingScheduleId) && this.deviceId.equals(other.deviceId) && this.name.equals(other.name) && this.scheduleStartsAt.equals(other.scheduleStartsAt) && this.scheduleEndsAt.equals(other.scheduleEndsAt) && this.createdAt.equals(other.createdAt) && this.automaticHeatingEnabled.equals(other.automaticHeatingEnabled) && this.automaticCoolingEnabled.equals(other.automaticCoolingEnabled) && this.hvacModeSetting.equals(other.hvacModeSetting) && this.coolingSetPointCelsius.equals(other.coolingSetPointCelsius) && this.heatingSetPointCelsius.equals(other.heatingSetPointCelsius) && this.coolingSetPointFahrenheit.equals(other.coolingSetPointFahrenheit) && this.heatingSetPointFahrenheit.equals(other.heatingSetPointFahrenheit) && this.manualOverrideAllowed.equals(other.manualOverrideAllowed);
    }

    public int hashCode() {
        return Objects.hash(this.climateSettingScheduleId, this.deviceId, this.name, this.scheduleStartsAt, this.scheduleEndsAt, this.createdAt, this.automaticHeatingEnabled, this.automaticCoolingEnabled, this.hvacModeSetting, this.coolingSetPointCelsius, this.heatingSetPointCelsius, this.coolingSetPointFahrenheit, this.heatingSetPointFahrenheit, this.manualOverrideAllowed);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static ClimateSettingScheduleIdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements ClimateSettingScheduleIdStage,
    DeviceIdStage,
    ScheduleStartsAtStage,
    ScheduleEndsAtStage,
    CreatedAtStage,
    _FinalStage {
        private String climateSettingScheduleId;
        private String deviceId;
        private String scheduleStartsAt;
        private String scheduleEndsAt;
        private OffsetDateTime createdAt;
        private Optional<Boolean> manualOverrideAllowed = Optional.empty();
        private Optional<Double> heatingSetPointFahrenheit = Optional.empty();
        private Optional<Double> coolingSetPointFahrenheit = Optional.empty();
        private Optional<Double> heatingSetPointCelsius = Optional.empty();
        private Optional<Double> coolingSetPointCelsius = Optional.empty();
        private Optional<HvacModeSetting> hvacModeSetting = Optional.empty();
        private Optional<Boolean> automaticCoolingEnabled = Optional.empty();
        private Optional<Boolean> automaticHeatingEnabled = Optional.empty();
        private Optional<String> name = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(ClimateSettingSchedule other) {
            this.climateSettingScheduleId(other.getClimateSettingScheduleId());
            this.deviceId(other.getDeviceId());
            this.name(other.getName());
            this.scheduleStartsAt(other.getScheduleStartsAt());
            this.scheduleEndsAt(other.getScheduleEndsAt());
            this.createdAt(other.getCreatedAt());
            this.automaticHeatingEnabled(other.getAutomaticHeatingEnabled());
            this.automaticCoolingEnabled(other.getAutomaticCoolingEnabled());
            this.hvacModeSetting(other.getHvacModeSetting());
            this.coolingSetPointCelsius(other.getCoolingSetPointCelsius());
            this.heatingSetPointCelsius(other.getHeatingSetPointCelsius());
            this.coolingSetPointFahrenheit(other.getCoolingSetPointFahrenheit());
            this.heatingSetPointFahrenheit(other.getHeatingSetPointFahrenheit());
            this.manualOverrideAllowed(other.getManualOverrideAllowed());
            return this;
        }

        @Override
        @JsonSetter(value="climate_setting_schedule_id")
        public DeviceIdStage climateSettingScheduleId(String climateSettingScheduleId) {
            this.climateSettingScheduleId = climateSettingScheduleId;
            return this;
        }

        @Override
        @JsonSetter(value="device_id")
        public ScheduleStartsAtStage deviceId(String deviceId) {
            this.deviceId = deviceId;
            return this;
        }

        @Override
        @JsonSetter(value="schedule_starts_at")
        public ScheduleEndsAtStage scheduleStartsAt(String scheduleStartsAt) {
            this.scheduleStartsAt = scheduleStartsAt;
            return this;
        }

        @Override
        @JsonSetter(value="schedule_ends_at")
        public CreatedAtStage scheduleEndsAt(String scheduleEndsAt) {
            this.scheduleEndsAt = scheduleEndsAt;
            return this;
        }

        @Override
        @JsonSetter(value="created_at")
        public _FinalStage createdAt(OffsetDateTime createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        @Override
        public _FinalStage manualOverrideAllowed(Boolean manualOverrideAllowed) {
            this.manualOverrideAllowed = Optional.of(manualOverrideAllowed);
            return this;
        }

        @Override
        @JsonSetter(value="manual_override_allowed", nulls=Nulls.SKIP)
        public _FinalStage manualOverrideAllowed(Optional<Boolean> manualOverrideAllowed) {
            this.manualOverrideAllowed = manualOverrideAllowed;
            return this;
        }

        @Override
        public _FinalStage heatingSetPointFahrenheit(Double heatingSetPointFahrenheit) {
            this.heatingSetPointFahrenheit = Optional.of(heatingSetPointFahrenheit);
            return this;
        }

        @Override
        @JsonSetter(value="heating_set_point_fahrenheit", nulls=Nulls.SKIP)
        public _FinalStage heatingSetPointFahrenheit(Optional<Double> heatingSetPointFahrenheit) {
            this.heatingSetPointFahrenheit = heatingSetPointFahrenheit;
            return this;
        }

        @Override
        public _FinalStage coolingSetPointFahrenheit(Double coolingSetPointFahrenheit) {
            this.coolingSetPointFahrenheit = Optional.of(coolingSetPointFahrenheit);
            return this;
        }

        @Override
        @JsonSetter(value="cooling_set_point_fahrenheit", nulls=Nulls.SKIP)
        public _FinalStage coolingSetPointFahrenheit(Optional<Double> coolingSetPointFahrenheit) {
            this.coolingSetPointFahrenheit = coolingSetPointFahrenheit;
            return this;
        }

        @Override
        public _FinalStage heatingSetPointCelsius(Double heatingSetPointCelsius) {
            this.heatingSetPointCelsius = Optional.of(heatingSetPointCelsius);
            return this;
        }

        @Override
        @JsonSetter(value="heating_set_point_celsius", nulls=Nulls.SKIP)
        public _FinalStage heatingSetPointCelsius(Optional<Double> heatingSetPointCelsius) {
            this.heatingSetPointCelsius = heatingSetPointCelsius;
            return this;
        }

        @Override
        public _FinalStage coolingSetPointCelsius(Double coolingSetPointCelsius) {
            this.coolingSetPointCelsius = Optional.of(coolingSetPointCelsius);
            return this;
        }

        @Override
        @JsonSetter(value="cooling_set_point_celsius", nulls=Nulls.SKIP)
        public _FinalStage coolingSetPointCelsius(Optional<Double> coolingSetPointCelsius) {
            this.coolingSetPointCelsius = coolingSetPointCelsius;
            return this;
        }

        @Override
        public _FinalStage hvacModeSetting(HvacModeSetting hvacModeSetting) {
            this.hvacModeSetting = Optional.of(hvacModeSetting);
            return this;
        }

        @Override
        @JsonSetter(value="hvac_mode_setting", nulls=Nulls.SKIP)
        public _FinalStage hvacModeSetting(Optional<HvacModeSetting> hvacModeSetting) {
            this.hvacModeSetting = hvacModeSetting;
            return this;
        }

        @Override
        public _FinalStage automaticCoolingEnabled(Boolean automaticCoolingEnabled) {
            this.automaticCoolingEnabled = Optional.of(automaticCoolingEnabled);
            return this;
        }

        @Override
        @JsonSetter(value="automatic_cooling_enabled", nulls=Nulls.SKIP)
        public _FinalStage automaticCoolingEnabled(Optional<Boolean> automaticCoolingEnabled) {
            this.automaticCoolingEnabled = automaticCoolingEnabled;
            return this;
        }

        @Override
        public _FinalStage automaticHeatingEnabled(Boolean automaticHeatingEnabled) {
            this.automaticHeatingEnabled = Optional.of(automaticHeatingEnabled);
            return this;
        }

        @Override
        @JsonSetter(value="automatic_heating_enabled", nulls=Nulls.SKIP)
        public _FinalStage automaticHeatingEnabled(Optional<Boolean> automaticHeatingEnabled) {
            this.automaticHeatingEnabled = automaticHeatingEnabled;
            return this;
        }

        @Override
        public _FinalStage name(String name) {
            this.name = Optional.of(name);
            return this;
        }

        @Override
        @JsonSetter(value="name", nulls=Nulls.SKIP)
        public _FinalStage name(Optional<String> name) {
            this.name = name;
            return this;
        }

        @Override
        public ClimateSettingSchedule build() {
            return new ClimateSettingSchedule(this.climateSettingScheduleId, this.deviceId, this.name, this.scheduleStartsAt, this.scheduleEndsAt, this.createdAt, this.automaticHeatingEnabled, this.automaticCoolingEnabled, this.hvacModeSetting, this.coolingSetPointCelsius, this.heatingSetPointCelsius, this.coolingSetPointFahrenheit, this.heatingSetPointFahrenheit, this.manualOverrideAllowed, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public ClimateSettingSchedule build();

        public _FinalStage name(Optional<String> var1);

        public _FinalStage name(String var1);

        public _FinalStage automaticHeatingEnabled(Optional<Boolean> var1);

        public _FinalStage automaticHeatingEnabled(Boolean var1);

        public _FinalStage automaticCoolingEnabled(Optional<Boolean> var1);

        public _FinalStage automaticCoolingEnabled(Boolean var1);

        public _FinalStage hvacModeSetting(Optional<HvacModeSetting> var1);

        public _FinalStage hvacModeSetting(HvacModeSetting var1);

        public _FinalStage coolingSetPointCelsius(Optional<Double> var1);

        public _FinalStage coolingSetPointCelsius(Double var1);

        public _FinalStage heatingSetPointCelsius(Optional<Double> var1);

        public _FinalStage heatingSetPointCelsius(Double var1);

        public _FinalStage coolingSetPointFahrenheit(Optional<Double> var1);

        public _FinalStage coolingSetPointFahrenheit(Double var1);

        public _FinalStage heatingSetPointFahrenheit(Optional<Double> var1);

        public _FinalStage heatingSetPointFahrenheit(Double var1);

        public _FinalStage manualOverrideAllowed(Optional<Boolean> var1);

        public _FinalStage manualOverrideAllowed(Boolean var1);
    }

    public static interface CreatedAtStage {
        public _FinalStage createdAt(OffsetDateTime var1);
    }

    public static interface ScheduleEndsAtStage {
        public CreatedAtStage scheduleEndsAt(String var1);
    }

    public static interface ScheduleStartsAtStage {
        public ScheduleEndsAtStage scheduleStartsAt(String var1);
    }

    public static interface DeviceIdStage {
        public ScheduleStartsAtStage deviceId(String var1);
    }

    public static interface ClimateSettingScheduleIdStage {
        public DeviceIdStage climateSettingScheduleId(String var1);

        public Builder from(ClimateSettingSchedule var1);
    }
}

