/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.seam.api.resources.thermostats.climatesettingschedules.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.seam.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder = ClimateSettingSchedulesGetRequest.Builder.class)
public final class ClimateSettingSchedulesGetRequest {
    private final Optional<String> climateSettingScheduleId;

    private final Optional<String> deviceId;

    private final Map<String, Object> additionalProperties;

    private ClimateSettingSchedulesGetRequest(
            Optional<String> climateSettingScheduleId,
            Optional<String> deviceId,
            Map<String, Object> additionalProperties) {
        this.climateSettingScheduleId = climateSettingScheduleId;
        this.deviceId = deviceId;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty("climate_setting_schedule_id")
    public Optional<String> getClimateSettingScheduleId() {
        return climateSettingScheduleId;
    }

    @JsonProperty("device_id")
    public Optional<String> getDeviceId() {
        return deviceId;
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof ClimateSettingSchedulesGetRequest && equalTo((ClimateSettingSchedulesGetRequest) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ClimateSettingSchedulesGetRequest other) {
        return climateSettingScheduleId.equals(other.climateSettingScheduleId) && deviceId.equals(other.deviceId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.climateSettingScheduleId, this.deviceId);
    }

    @Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder {
        private Optional<String> climateSettingScheduleId = Optional.empty();

        private Optional<String> deviceId = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        public Builder from(ClimateSettingSchedulesGetRequest other) {
            climateSettingScheduleId(other.getClimateSettingScheduleId());
            deviceId(other.getDeviceId());
            return this;
        }

        @JsonSetter(value = "climate_setting_schedule_id", nulls = Nulls.SKIP)
        public Builder climateSettingScheduleId(Optional<String> climateSettingScheduleId) {
            this.climateSettingScheduleId = climateSettingScheduleId;
            return this;
        }

        public Builder climateSettingScheduleId(String climateSettingScheduleId) {
            this.climateSettingScheduleId = Optional.of(climateSettingScheduleId);
            return this;
        }

        @JsonSetter(value = "device_id", nulls = Nulls.SKIP)
        public Builder deviceId(Optional<String> deviceId) {
            this.deviceId = deviceId;
            return this;
        }

        public Builder deviceId(String deviceId) {
            this.deviceId = Optional.of(deviceId);
            return this;
        }

        public ClimateSettingSchedulesGetRequest build() {
            return new ClimateSettingSchedulesGetRequest(climateSettingScheduleId, deviceId, additionalProperties);
        }
    }
}
