/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.seam.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.seam.api.core.ObjectMappers;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder = LocksListResponse.Builder.class)
public final class LocksListResponse {
    private final Optional<Object> locks;

    private final List<Device> devices;

    private final boolean ok;

    private final Map<String, Object> additionalProperties;

    private LocksListResponse(
            Optional<Object> locks, List<Device> devices, boolean ok, Map<String, Object> additionalProperties) {
        this.locks = locks;
        this.devices = devices;
        this.ok = ok;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty("locks")
    public Optional<Object> getLocks() {
        return locks;
    }

    @JsonProperty("devices")
    public List<Device> getDevices() {
        return devices;
    }

    @JsonProperty("ok")
    public boolean getOk() {
        return ok;
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof LocksListResponse && equalTo((LocksListResponse) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(LocksListResponse other) {
        return locks.equals(other.locks) && devices.equals(other.devices) && ok == other.ok;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.locks, this.devices, this.ok);
    }

    @Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static OkStage builder() {
        return new Builder();
    }

    public interface OkStage {
        _FinalStage ok(boolean ok);

        Builder from(LocksListResponse other);
    }

    public interface _FinalStage {
        LocksListResponse build();

        _FinalStage locks(Optional<Object> locks);

        _FinalStage locks(Object locks);

        _FinalStage devices(List<Device> devices);

        _FinalStage addDevices(Device devices);

        _FinalStage addAllDevices(List<Device> devices);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements OkStage, _FinalStage {
        private boolean ok;

        private List<Device> devices = new ArrayList<>();

        private Optional<Object> locks = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @Override
        public Builder from(LocksListResponse other) {
            locks(other.getLocks());
            devices(other.getDevices());
            ok(other.getOk());
            return this;
        }

        @Override
        @JsonSetter("ok")
        public _FinalStage ok(boolean ok) {
            this.ok = ok;
            return this;
        }

        @Override
        public _FinalStage addAllDevices(List<Device> devices) {
            this.devices.addAll(devices);
            return this;
        }

        @Override
        public _FinalStage addDevices(Device devices) {
            this.devices.add(devices);
            return this;
        }

        @Override
        @JsonSetter(value = "devices", nulls = Nulls.SKIP)
        public _FinalStage devices(List<Device> devices) {
            this.devices.clear();
            this.devices.addAll(devices);
            return this;
        }

        @Override
        public _FinalStage locks(Object locks) {
            this.locks = Optional.of(locks);
            return this;
        }

        @Override
        @JsonSetter(value = "locks", nulls = Nulls.SKIP)
        public _FinalStage locks(Optional<Object> locks) {
            this.locks = locks;
            return this;
        }

        @Override
        public LocksListResponse build() {
            return new LocksListResponse(locks, devices, ok, additionalProperties);
        }
    }
}
