/*
 * Decompiled with CFR 0.152.
 */
package com.seam.api.types;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.seam.api.core.ObjectMappers;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class LocksListResponse {
    private final Optional<Object> locks;
    private final Optional<Object> devices;
    private final boolean ok;

    private LocksListResponse(Optional<Object> locks, Optional<Object> devices, boolean ok) {
        this.locks = locks;
        this.devices = devices;
        this.ok = ok;
    }

    @JsonProperty(value="locks")
    public Optional<Object> getLocks() {
        return this.locks;
    }

    @JsonProperty(value="devices")
    public Optional<Object> getDevices() {
        return this.devices;
    }

    @JsonProperty(value="ok")
    public boolean getOk() {
        return this.ok;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof LocksListResponse && this.equalTo((LocksListResponse)other);
    }

    private boolean equalTo(LocksListResponse other) {
        return this.locks.equals(other.locks) && this.devices.equals(other.devices) && this.ok == other.ok;
    }

    public int hashCode() {
        return Objects.hash(this.locks, this.devices, this.ok);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static OkStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements OkStage,
    _FinalStage {
        private boolean ok;
        private Optional<Object> devices = Optional.empty();
        private Optional<Object> locks = Optional.empty();

        private Builder() {
        }

        @Override
        public Builder from(LocksListResponse other) {
            this.locks(other.getLocks());
            this.devices(other.getDevices());
            this.ok(other.getOk());
            return this;
        }

        @Override
        @JsonSetter(value="ok")
        public _FinalStage ok(boolean ok) {
            this.ok = ok;
            return this;
        }

        @Override
        public _FinalStage devices(Object devices) {
            this.devices = Optional.of(devices);
            return this;
        }

        @Override
        @JsonSetter(value="devices", nulls=Nulls.SKIP)
        public _FinalStage devices(Optional<Object> devices) {
            this.devices = devices;
            return this;
        }

        @Override
        public _FinalStage locks(Object locks) {
            this.locks = Optional.of(locks);
            return this;
        }

        @Override
        @JsonSetter(value="locks", nulls=Nulls.SKIP)
        public _FinalStage locks(Optional<Object> locks) {
            this.locks = locks;
            return this;
        }

        @Override
        public LocksListResponse build() {
            return new LocksListResponse(this.locks, this.devices, this.ok);
        }
    }

    public static interface _FinalStage {
        public LocksListResponse build();

        public _FinalStage locks(Optional<Object> var1);

        public _FinalStage locks(Object var1);

        public _FinalStage devices(Optional<Object> var1);

        public _FinalStage devices(Object var1);
    }

    public static interface OkStage {
        public _FinalStage ok(boolean var1);

        public Builder from(LocksListResponse var1);
    }
}

