/*
 * Decompiled with CFR 0.152.
 */
package com.seam.api.resources.accesscodes.unmanaged.requests;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.seam.api.core.ObjectMappers;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class UnmanagedGetRequest {
    private final Optional<String> deviceId;
    private final Optional<String> accessCodeId;
    private final Optional<String> code;

    private UnmanagedGetRequest(Optional<String> deviceId, Optional<String> accessCodeId, Optional<String> code) {
        this.deviceId = deviceId;
        this.accessCodeId = accessCodeId;
        this.code = code;
    }

    @JsonProperty(value="device_id")
    public Optional<String> getDeviceId() {
        return this.deviceId;
    }

    @JsonProperty(value="access_code_id")
    public Optional<String> getAccessCodeId() {
        return this.accessCodeId;
    }

    @JsonProperty(value="code")
    public Optional<String> getCode() {
        return this.code;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof UnmanagedGetRequest && this.equalTo((UnmanagedGetRequest)other);
    }

    private boolean equalTo(UnmanagedGetRequest other) {
        return this.deviceId.equals(other.deviceId) && this.accessCodeId.equals(other.accessCodeId) && this.code.equals(other.code);
    }

    public int hashCode() {
        return Objects.hash(this.deviceId, this.accessCodeId, this.code);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> deviceId = Optional.empty();
        private Optional<String> accessCodeId = Optional.empty();
        private Optional<String> code = Optional.empty();

        private Builder() {
        }

        public Builder from(UnmanagedGetRequest other) {
            this.deviceId(other.getDeviceId());
            this.accessCodeId(other.getAccessCodeId());
            this.code(other.getCode());
            return this;
        }

        @JsonSetter(value="device_id", nulls=Nulls.SKIP)
        public Builder deviceId(Optional<String> deviceId) {
            this.deviceId = deviceId;
            return this;
        }

        public Builder deviceId(String deviceId) {
            this.deviceId = Optional.of(deviceId);
            return this;
        }

        @JsonSetter(value="access_code_id", nulls=Nulls.SKIP)
        public Builder accessCodeId(Optional<String> accessCodeId) {
            this.accessCodeId = accessCodeId;
            return this;
        }

        public Builder accessCodeId(String accessCodeId) {
            this.accessCodeId = Optional.of(accessCodeId);
            return this;
        }

        @JsonSetter(value="code", nulls=Nulls.SKIP)
        public Builder code(Optional<String> code) {
            this.code = code;
            return this;
        }

        public Builder code(String code) {
            this.code = Optional.of(code);
            return this;
        }

        public UnmanagedGetRequest build() {
            return new UnmanagedGetRequest(this.deviceId, this.accessCodeId, this.code);
        }
    }
}

