/*
 * Decompiled with CFR 0.152.
 */
package com.seam.api.resources.connectedaccounts;

import com.seam.api.core.ApiError;
import com.seam.api.core.ClientOptions;
import com.seam.api.core.ObjectMappers;
import com.seam.api.core.RequestOptions;
import com.seam.api.resources.connectedaccounts.requests.ConnectedAccountsDeleteRequest;
import com.seam.api.types.ConnectedAccountsDeleteResponse;
import com.seam.api.types.ConnectedAccountsGetRequest;
import com.seam.api.types.ConnectedAccountsGetResponse;
import com.seam.api.types.ConnectedAccountsListResponse;
import java.io.IOException;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class ConnectedAccountsClient {
    protected final ClientOptions clientOptions;

    public ConnectedAccountsClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
    }

    public ConnectedAccountsDeleteResponse delete(ConnectedAccountsDeleteRequest request) {
        return this.delete(request, null);
    }

    public ConnectedAccountsDeleteResponse delete(ConnectedAccountsDeleteRequest request, RequestOptions requestOptions) {
        RequestBody body;
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("connected_accounts/delete").build();
        try {
            body = RequestBody.create((byte[])ObjectMappers.JSON_MAPPER.writeValueAsBytes((Object)request), (MediaType)MediaType.parse((String)"application/json"));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("POST", body).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json").build();
        try {
            Response response = this.clientOptions.httpClient().newCall(okhttpRequest).execute();
            if (response.isSuccessful()) {
                return (ConnectedAccountsDeleteResponse)ObjectMappers.JSON_MAPPER.readValue(response.body().string(), ConnectedAccountsDeleteResponse.class);
            }
            throw new ApiError(response.code(), ObjectMappers.JSON_MAPPER.readValue(response.body().string(), Object.class));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public ConnectedAccountsGetResponse get(ConnectedAccountsGetRequest request) {
        return this.get(request, null);
    }

    public ConnectedAccountsGetResponse get(ConnectedAccountsGetRequest request, RequestOptions requestOptions) {
        RequestBody body;
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("connected_accounts/get").build();
        try {
            body = RequestBody.create((byte[])ObjectMappers.JSON_MAPPER.writeValueAsBytes((Object)request), (MediaType)MediaType.parse((String)"application/json"));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("POST", body).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json").build();
        try {
            Response response = this.clientOptions.httpClient().newCall(okhttpRequest).execute();
            if (response.isSuccessful()) {
                return (ConnectedAccountsGetResponse)ObjectMappers.JSON_MAPPER.readValue(response.body().string(), ConnectedAccountsGetResponse.class);
            }
            throw new ApiError(response.code(), ObjectMappers.JSON_MAPPER.readValue(response.body().string(), Object.class));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public ConnectedAccountsListResponse list() {
        return this.list(null);
    }

    public ConnectedAccountsListResponse list(RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("connected_accounts/list").build();
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("POST", RequestBody.create((String)"", null)).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json").build();
        try {
            Response response = this.clientOptions.httpClient().newCall(okhttpRequest).execute();
            if (response.isSuccessful()) {
                return (ConnectedAccountsListResponse)ObjectMappers.JSON_MAPPER.readValue(response.body().string(), ConnectedAccountsListResponse.class);
            }
            throw new ApiError(response.code(), ObjectMappers.JSON_MAPPER.readValue(response.body().string(), Object.class));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

