/*
 * Decompiled with CFR 0.152.
 */
package com.seam.api.resources.thermostats;

import com.seam.api.core.ApiError;
import com.seam.api.core.ClientOptions;
import com.seam.api.core.ObjectMappers;
import com.seam.api.core.RequestOptions;
import com.seam.api.core.Suppliers;
import com.seam.api.resources.thermostats.climatesettingschedules.ClimateSettingSchedulesClient;
import com.seam.api.resources.thermostats.requests.ThermostatsGetRequest;
import com.seam.api.resources.thermostats.requests.ThermostatsHeatRequest;
import com.seam.api.resources.thermostats.requests.ThermostatsListRequest;
import com.seam.api.resources.thermostats.requests.ThermostatsUpdateRequest;
import com.seam.api.types.ThermostatsGetResponse;
import com.seam.api.types.ThermostatsHeatResponse;
import com.seam.api.types.ThermostatsListResponse;
import com.seam.api.types.ThermostatsUpdateResponse;
import java.io.IOException;
import java.util.function.Supplier;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class ThermostatsClient {
    protected final ClientOptions clientOptions;
    protected final Supplier<ClimateSettingSchedulesClient> climateSettingSchedulesClient;

    public ThermostatsClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.climateSettingSchedulesClient = Suppliers.memoize(() -> new ClimateSettingSchedulesClient(clientOptions));
    }

    public ThermostatsGetResponse get(ThermostatsGetRequest request) {
        return this.get(request, null);
    }

    public ThermostatsGetResponse get(ThermostatsGetRequest request, RequestOptions requestOptions) {
        RequestBody body;
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("thermostats/get").build();
        try {
            body = RequestBody.create((byte[])ObjectMappers.JSON_MAPPER.writeValueAsBytes((Object)request), (MediaType)MediaType.parse((String)"application/json"));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("POST", body).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json").build();
        try {
            Response response = this.clientOptions.httpClient().newCall(okhttpRequest).execute();
            if (response.isSuccessful()) {
                return (ThermostatsGetResponse)ObjectMappers.JSON_MAPPER.readValue(response.body().string(), ThermostatsGetResponse.class);
            }
            throw new ApiError(response.code(), ObjectMappers.JSON_MAPPER.readValue(response.body().string(), Object.class));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public ThermostatsGetResponse get() {
        return this.get(ThermostatsGetRequest.builder().build());
    }

    public ThermostatsHeatResponse heat(ThermostatsHeatRequest request) {
        return this.heat(request, null);
    }

    public ThermostatsHeatResponse heat(ThermostatsHeatRequest request, RequestOptions requestOptions) {
        RequestBody body;
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("thermostats/heat").build();
        try {
            body = RequestBody.create((byte[])ObjectMappers.JSON_MAPPER.writeValueAsBytes((Object)request), (MediaType)MediaType.parse((String)"application/json"));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("POST", body).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json").build();
        try {
            Response response = this.clientOptions.httpClient().newCall(okhttpRequest).execute();
            if (response.isSuccessful()) {
                return (ThermostatsHeatResponse)ObjectMappers.JSON_MAPPER.readValue(response.body().string(), ThermostatsHeatResponse.class);
            }
            throw new ApiError(response.code(), ObjectMappers.JSON_MAPPER.readValue(response.body().string(), Object.class));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public ThermostatsListResponse list(ThermostatsListRequest request) {
        return this.list(request, null);
    }

    public ThermostatsListResponse list(ThermostatsListRequest request, RequestOptions requestOptions) {
        RequestBody body;
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("thermostats/list").build();
        try {
            body = RequestBody.create((byte[])ObjectMappers.JSON_MAPPER.writeValueAsBytes((Object)request), (MediaType)MediaType.parse((String)"application/json"));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("POST", body).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json").build();
        try {
            Response response = this.clientOptions.httpClient().newCall(okhttpRequest).execute();
            if (response.isSuccessful()) {
                return (ThermostatsListResponse)ObjectMappers.JSON_MAPPER.readValue(response.body().string(), ThermostatsListResponse.class);
            }
            throw new ApiError(response.code(), ObjectMappers.JSON_MAPPER.readValue(response.body().string(), Object.class));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public ThermostatsListResponse list() {
        return this.list(ThermostatsListRequest.builder().build());
    }

    public ThermostatsUpdateResponse update(ThermostatsUpdateRequest request) {
        return this.update(request, null);
    }

    public ThermostatsUpdateResponse update(ThermostatsUpdateRequest request, RequestOptions requestOptions) {
        RequestBody body;
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("thermostats/update").build();
        try {
            body = RequestBody.create((byte[])ObjectMappers.JSON_MAPPER.writeValueAsBytes((Object)request), (MediaType)MediaType.parse((String)"application/json"));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("POST", body).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json").build();
        try {
            Response response = this.clientOptions.httpClient().newCall(okhttpRequest).execute();
            if (response.isSuccessful()) {
                return (ThermostatsUpdateResponse)ObjectMappers.JSON_MAPPER.readValue(response.body().string(), ThermostatsUpdateResponse.class);
            }
            throw new ApiError(response.code(), ObjectMappers.JSON_MAPPER.readValue(response.body().string(), Object.class));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public ClimateSettingSchedulesClient climateSettingSchedules() {
        return this.climateSettingSchedulesClient.get();
    }
}

