/*
 * Decompiled with CFR 0.152.
 */
package com.seam.api.types;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.seam.api.core.ObjectMappers;
import com.seam.api.types.UnmanagedDeviceCapabilitiesSupportedItem;
import com.seam.api.types.UnmanagedDeviceDeviceType;
import com.seam.api.types.UnmanagedDeviceErrorsItem;
import com.seam.api.types.UnmanagedDeviceProperties;
import com.seam.api.types.UnmanagedDeviceWarningsItem;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class UnmanagedDevice {
    private final String deviceId;
    private final UnmanagedDeviceDeviceType deviceType;
    private final String connectedAccountId;
    private final List<UnmanagedDeviceCapabilitiesSupportedItem> capabilitiesSupported;
    private final String workspaceId;
    private final List<UnmanagedDeviceErrorsItem> errors;
    private final List<UnmanagedDeviceWarningsItem> warnings;
    private final OffsetDateTime createdAt;
    private final String isManaged;
    private final UnmanagedDeviceProperties properties;

    private UnmanagedDevice(String deviceId, UnmanagedDeviceDeviceType deviceType, String connectedAccountId, List<UnmanagedDeviceCapabilitiesSupportedItem> capabilitiesSupported, String workspaceId, List<UnmanagedDeviceErrorsItem> errors, List<UnmanagedDeviceWarningsItem> warnings, OffsetDateTime createdAt, String isManaged, UnmanagedDeviceProperties properties) {
        this.deviceId = deviceId;
        this.deviceType = deviceType;
        this.connectedAccountId = connectedAccountId;
        this.capabilitiesSupported = capabilitiesSupported;
        this.workspaceId = workspaceId;
        this.errors = errors;
        this.warnings = warnings;
        this.createdAt = createdAt;
        this.isManaged = isManaged;
        this.properties = properties;
    }

    @JsonProperty(value="device_id")
    public String getDeviceId() {
        return this.deviceId;
    }

    @JsonProperty(value="device_type")
    public UnmanagedDeviceDeviceType getDeviceType() {
        return this.deviceType;
    }

    @JsonProperty(value="connected_account_id")
    public String getConnectedAccountId() {
        return this.connectedAccountId;
    }

    @JsonProperty(value="capabilities_supported")
    public List<UnmanagedDeviceCapabilitiesSupportedItem> getCapabilitiesSupported() {
        return this.capabilitiesSupported;
    }

    @JsonProperty(value="workspace_id")
    public String getWorkspaceId() {
        return this.workspaceId;
    }

    @JsonProperty(value="errors")
    public List<UnmanagedDeviceErrorsItem> getErrors() {
        return this.errors;
    }

    @JsonProperty(value="warnings")
    public List<UnmanagedDeviceWarningsItem> getWarnings() {
        return this.warnings;
    }

    @JsonProperty(value="created_at")
    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="is_managed")
    public String getIsManaged() {
        return this.isManaged;
    }

    @JsonProperty(value="properties")
    public UnmanagedDeviceProperties getProperties() {
        return this.properties;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof UnmanagedDevice && this.equalTo((UnmanagedDevice)other);
    }

    private boolean equalTo(UnmanagedDevice other) {
        return this.deviceId.equals(other.deviceId) && this.deviceType.equals((Object)other.deviceType) && this.connectedAccountId.equals(other.connectedAccountId) && this.capabilitiesSupported.equals(other.capabilitiesSupported) && this.workspaceId.equals(other.workspaceId) && this.errors.equals(other.errors) && this.warnings.equals(other.warnings) && this.createdAt.equals(other.createdAt) && this.isManaged.equals(other.isManaged) && this.properties.equals(other.properties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.deviceId, this.deviceType, this.connectedAccountId, this.capabilitiesSupported, this.workspaceId, this.errors, this.warnings, this.createdAt, this.isManaged, this.properties});
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static DeviceIdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements DeviceIdStage,
    DeviceTypeStage,
    ConnectedAccountIdStage,
    WorkspaceIdStage,
    CreatedAtStage,
    IsManagedStage,
    PropertiesStage,
    _FinalStage {
        private String deviceId;
        private UnmanagedDeviceDeviceType deviceType;
        private String connectedAccountId;
        private String workspaceId;
        private OffsetDateTime createdAt;
        private String isManaged;
        private UnmanagedDeviceProperties properties;
        private List<UnmanagedDeviceWarningsItem> warnings = new ArrayList<UnmanagedDeviceWarningsItem>();
        private List<UnmanagedDeviceErrorsItem> errors = new ArrayList<UnmanagedDeviceErrorsItem>();
        private List<UnmanagedDeviceCapabilitiesSupportedItem> capabilitiesSupported = new ArrayList<UnmanagedDeviceCapabilitiesSupportedItem>();

        private Builder() {
        }

        @Override
        public Builder from(UnmanagedDevice other) {
            this.deviceId(other.getDeviceId());
            this.deviceType(other.getDeviceType());
            this.connectedAccountId(other.getConnectedAccountId());
            this.capabilitiesSupported(other.getCapabilitiesSupported());
            this.workspaceId(other.getWorkspaceId());
            this.errors(other.getErrors());
            this.warnings(other.getWarnings());
            this.createdAt(other.getCreatedAt());
            this.isManaged(other.getIsManaged());
            this.properties(other.getProperties());
            return this;
        }

        @Override
        @JsonSetter(value="device_id")
        public DeviceTypeStage deviceId(String deviceId) {
            this.deviceId = deviceId;
            return this;
        }

        @Override
        @JsonSetter(value="device_type")
        public ConnectedAccountIdStage deviceType(UnmanagedDeviceDeviceType deviceType) {
            this.deviceType = deviceType;
            return this;
        }

        @Override
        @JsonSetter(value="connected_account_id")
        public WorkspaceIdStage connectedAccountId(String connectedAccountId) {
            this.connectedAccountId = connectedAccountId;
            return this;
        }

        @Override
        @JsonSetter(value="workspace_id")
        public CreatedAtStage workspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
            return this;
        }

        @Override
        @JsonSetter(value="created_at")
        public IsManagedStage createdAt(OffsetDateTime createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        @Override
        @JsonSetter(value="is_managed")
        public PropertiesStage isManaged(String isManaged) {
            this.isManaged = isManaged;
            return this;
        }

        @Override
        @JsonSetter(value="properties")
        public _FinalStage properties(UnmanagedDeviceProperties properties) {
            this.properties = properties;
            return this;
        }

        @Override
        public _FinalStage addAllWarnings(List<UnmanagedDeviceWarningsItem> warnings) {
            this.warnings.addAll(warnings);
            return this;
        }

        @Override
        public _FinalStage addWarnings(UnmanagedDeviceWarningsItem warnings) {
            this.warnings.add(warnings);
            return this;
        }

        @Override
        @JsonSetter(value="warnings", nulls=Nulls.SKIP)
        public _FinalStage warnings(List<UnmanagedDeviceWarningsItem> warnings) {
            this.warnings.clear();
            this.warnings.addAll(warnings);
            return this;
        }

        @Override
        public _FinalStage addAllErrors(List<UnmanagedDeviceErrorsItem> errors) {
            this.errors.addAll(errors);
            return this;
        }

        @Override
        public _FinalStage addErrors(UnmanagedDeviceErrorsItem errors) {
            this.errors.add(errors);
            return this;
        }

        @Override
        @JsonSetter(value="errors", nulls=Nulls.SKIP)
        public _FinalStage errors(List<UnmanagedDeviceErrorsItem> errors) {
            this.errors.clear();
            this.errors.addAll(errors);
            return this;
        }

        @Override
        public _FinalStage addAllCapabilitiesSupported(List<UnmanagedDeviceCapabilitiesSupportedItem> capabilitiesSupported) {
            this.capabilitiesSupported.addAll(capabilitiesSupported);
            return this;
        }

        @Override
        public _FinalStage addCapabilitiesSupported(UnmanagedDeviceCapabilitiesSupportedItem capabilitiesSupported) {
            this.capabilitiesSupported.add(capabilitiesSupported);
            return this;
        }

        @Override
        @JsonSetter(value="capabilities_supported", nulls=Nulls.SKIP)
        public _FinalStage capabilitiesSupported(List<UnmanagedDeviceCapabilitiesSupportedItem> capabilitiesSupported) {
            this.capabilitiesSupported.clear();
            this.capabilitiesSupported.addAll(capabilitiesSupported);
            return this;
        }

        @Override
        public UnmanagedDevice build() {
            return new UnmanagedDevice(this.deviceId, this.deviceType, this.connectedAccountId, this.capabilitiesSupported, this.workspaceId, this.errors, this.warnings, this.createdAt, this.isManaged, this.properties);
        }
    }

    public static interface _FinalStage {
        public UnmanagedDevice build();

        public _FinalStage capabilitiesSupported(List<UnmanagedDeviceCapabilitiesSupportedItem> var1);

        public _FinalStage addCapabilitiesSupported(UnmanagedDeviceCapabilitiesSupportedItem var1);

        public _FinalStage addAllCapabilitiesSupported(List<UnmanagedDeviceCapabilitiesSupportedItem> var1);

        public _FinalStage errors(List<UnmanagedDeviceErrorsItem> var1);

        public _FinalStage addErrors(UnmanagedDeviceErrorsItem var1);

        public _FinalStage addAllErrors(List<UnmanagedDeviceErrorsItem> var1);

        public _FinalStage warnings(List<UnmanagedDeviceWarningsItem> var1);

        public _FinalStage addWarnings(UnmanagedDeviceWarningsItem var1);

        public _FinalStage addAllWarnings(List<UnmanagedDeviceWarningsItem> var1);
    }

    public static interface PropertiesStage {
        public _FinalStage properties(UnmanagedDeviceProperties var1);
    }

    public static interface IsManagedStage {
        public PropertiesStage isManaged(String var1);
    }

    public static interface CreatedAtStage {
        public IsManagedStage createdAt(OffsetDateTime var1);
    }

    public static interface WorkspaceIdStage {
        public CreatedAtStage workspaceId(String var1);
    }

    public static interface ConnectedAccountIdStage {
        public WorkspaceIdStage connectedAccountId(String var1);
    }

    public static interface DeviceTypeStage {
        public ConnectedAccountIdStage deviceType(UnmanagedDeviceDeviceType var1);
    }

    public static interface DeviceIdStage {
        public DeviceTypeStage deviceId(String var1);

        public Builder from(UnmanagedDevice var1);
    }
}

