/*
 * Decompiled with CFR 0.152.
 */
package com.seam.api.types;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.seam.api.core.ObjectMappers;
import com.seam.api.types.Workspace;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class WorkspacesListResponse {
    private final List<Workspace> workspaces;
    private final boolean ok;

    private WorkspacesListResponse(List<Workspace> workspaces, boolean ok) {
        this.workspaces = workspaces;
        this.ok = ok;
    }

    @JsonProperty(value="workspaces")
    public List<Workspace> getWorkspaces() {
        return this.workspaces;
    }

    @JsonProperty(value="ok")
    public boolean getOk() {
        return this.ok;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof WorkspacesListResponse && this.equalTo((WorkspacesListResponse)other);
    }

    private boolean equalTo(WorkspacesListResponse other) {
        return this.workspaces.equals(other.workspaces) && this.ok == other.ok;
    }

    public int hashCode() {
        return Objects.hash(this.workspaces, this.ok);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static OkStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements OkStage,
    _FinalStage {
        private boolean ok;
        private List<Workspace> workspaces = new ArrayList<Workspace>();

        private Builder() {
        }

        @Override
        public Builder from(WorkspacesListResponse other) {
            this.workspaces(other.getWorkspaces());
            this.ok(other.getOk());
            return this;
        }

        @Override
        @JsonSetter(value="ok")
        public _FinalStage ok(boolean ok) {
            this.ok = ok;
            return this;
        }

        @Override
        public _FinalStage addAllWorkspaces(List<Workspace> workspaces) {
            this.workspaces.addAll(workspaces);
            return this;
        }

        @Override
        public _FinalStage addWorkspaces(Workspace workspaces) {
            this.workspaces.add(workspaces);
            return this;
        }

        @Override
        @JsonSetter(value="workspaces", nulls=Nulls.SKIP)
        public _FinalStage workspaces(List<Workspace> workspaces) {
            this.workspaces.clear();
            this.workspaces.addAll(workspaces);
            return this;
        }

        @Override
        public WorkspacesListResponse build() {
            return new WorkspacesListResponse(this.workspaces, this.ok);
        }
    }

    public static interface _FinalStage {
        public WorkspacesListResponse build();

        public _FinalStage workspaces(List<Workspace> var1);

        public _FinalStage addWorkspaces(Workspace var1);

        public _FinalStage addAllWorkspaces(List<Workspace> var1);
    }

    public static interface OkStage {
        public _FinalStage ok(boolean var1);

        public Builder from(WorkspacesListResponse var1);
    }
}

