/*
 * Decompiled with CFR 0.152.
 */
package com.seam.api.types;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.seam.api.core.ObjectMappers;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class LocksGetResponse {
    private final Optional<Object> lock;
    private final Optional<Object> device;
    private final boolean ok;

    private LocksGetResponse(Optional<Object> lock, Optional<Object> device, boolean ok) {
        this.lock = lock;
        this.device = device;
        this.ok = ok;
    }

    @JsonProperty(value="lock")
    public Optional<Object> getLock() {
        return this.lock;
    }

    @JsonProperty(value="device")
    public Optional<Object> getDevice() {
        return this.device;
    }

    @JsonProperty(value="ok")
    public boolean getOk() {
        return this.ok;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof LocksGetResponse && this.equalTo((LocksGetResponse)other);
    }

    private boolean equalTo(LocksGetResponse other) {
        return this.lock.equals(other.lock) && this.device.equals(other.device) && this.ok == other.ok;
    }

    public int hashCode() {
        return Objects.hash(this.lock, this.device, this.ok);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static OkStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements OkStage,
    _FinalStage {
        private boolean ok;
        private Optional<Object> device = Optional.empty();
        private Optional<Object> lock = Optional.empty();

        private Builder() {
        }

        @Override
        public Builder from(LocksGetResponse other) {
            this.lock(other.getLock());
            this.device(other.getDevice());
            this.ok(other.getOk());
            return this;
        }

        @Override
        @JsonSetter(value="ok")
        public _FinalStage ok(boolean ok) {
            this.ok = ok;
            return this;
        }

        @Override
        public _FinalStage device(Object device) {
            this.device = Optional.of(device);
            return this;
        }

        @Override
        @JsonSetter(value="device", nulls=Nulls.SKIP)
        public _FinalStage device(Optional<Object> device) {
            this.device = device;
            return this;
        }

        @Override
        public _FinalStage lock(Object lock) {
            this.lock = Optional.of(lock);
            return this;
        }

        @Override
        @JsonSetter(value="lock", nulls=Nulls.SKIP)
        public _FinalStage lock(Optional<Object> lock) {
            this.lock = lock;
            return this;
        }

        @Override
        public LocksGetResponse build() {
            return new LocksGetResponse(this.lock, this.device, this.ok);
        }
    }

    public static interface _FinalStage {
        public LocksGetResponse build();

        public _FinalStage lock(Optional<Object> var1);

        public _FinalStage lock(Object var1);

        public _FinalStage device(Optional<Object> var1);

        public _FinalStage device(Object var1);
    }

    public static interface OkStage {
        public _FinalStage ok(boolean var1);

        public Builder from(LocksGetResponse var1);
    }
}

