/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.seam.api.resources.noisesensors.noisethresholds;

import com.seam.api.core.ApiError;
import com.seam.api.core.ClientOptions;
import com.seam.api.core.ObjectMappers;
import com.seam.api.core.RequestOptions;
import com.seam.api.resources.noisesensors.noisethresholds.requests.NoiseThresholdsCreateRequest;
import com.seam.api.resources.noisesensors.noisethresholds.requests.NoiseThresholdsDeleteRequest;
import com.seam.api.resources.noisesensors.noisethresholds.requests.NoiseThresholdsGetRequest;
import com.seam.api.resources.noisesensors.noisethresholds.requests.NoiseThresholdsListRequest;
import com.seam.api.resources.noisesensors.noisethresholds.requests.NoiseThresholdsUpdateRequest;
import com.seam.api.types.ActionAttempt;
import com.seam.api.types.NoiseThreshold;
import com.seam.api.types.NoiseThresholdsCreateResponse;
import com.seam.api.types.NoiseThresholdsDeleteResponse;
import com.seam.api.types.NoiseThresholdsGetResponse;
import com.seam.api.types.NoiseThresholdsListResponse;
import com.seam.api.types.NoiseThresholdsUpdateResponse;
import java.io.IOException;
import java.util.List;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class NoiseThresholdsClient {
    protected final ClientOptions clientOptions;

    public NoiseThresholdsClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
    }

    public ActionAttempt create(NoiseThresholdsCreateRequest request) {
        return create(request, null);
    }

    public ActionAttempt create(NoiseThresholdsCreateRequest request, RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse(this.clientOptions.environment().getUrl())
                .newBuilder()
                .addPathSegments("noise_sensors/noise_thresholds/create")
                .build();
        RequestBody body;
        try {
            body = RequestBody.create(
                    ObjectMappers.JSON_MAPPER.writeValueAsBytes(request), MediaType.parse("application/json"));
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
        Request okhttpRequest = new Request.Builder()
                .url(httpUrl)
                .method("POST", body)
                .headers(Headers.of(clientOptions.headers(requestOptions)))
                .addHeader("Content-Type", "application/json")
                .build();
        try {
            Response response =
                    clientOptions.httpClient().newCall(okhttpRequest).execute();
            if (response.isSuccessful()) {
                NoiseThresholdsCreateResponse parsedResponse = ObjectMappers.JSON_MAPPER.readValue(
                        response.body().string(), NoiseThresholdsCreateResponse.class);
                return parsedResponse.getActionAttempt();
            }
            throw new ApiError(
                    response.code(),
                    ObjectMappers.JSON_MAPPER.readValue(response.body().string(), Object.class));
        } catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public ActionAttempt delete(NoiseThresholdsDeleteRequest request) {
        return delete(request, null);
    }

    public ActionAttempt delete(NoiseThresholdsDeleteRequest request, RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse(this.clientOptions.environment().getUrl())
                .newBuilder()
                .addPathSegments("noise_sensors/noise_thresholds/delete")
                .build();
        RequestBody body;
        try {
            body = RequestBody.create(
                    ObjectMappers.JSON_MAPPER.writeValueAsBytes(request), MediaType.parse("application/json"));
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
        Request okhttpRequest = new Request.Builder()
                .url(httpUrl)
                .method("POST", body)
                .headers(Headers.of(clientOptions.headers(requestOptions)))
                .addHeader("Content-Type", "application/json")
                .build();
        try {
            Response response =
                    clientOptions.httpClient().newCall(okhttpRequest).execute();
            if (response.isSuccessful()) {
                NoiseThresholdsDeleteResponse parsedResponse = ObjectMappers.JSON_MAPPER.readValue(
                        response.body().string(), NoiseThresholdsDeleteResponse.class);
                return parsedResponse.getActionAttempt();
            }
            throw new ApiError(
                    response.code(),
                    ObjectMappers.JSON_MAPPER.readValue(response.body().string(), Object.class));
        } catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public NoiseThreshold get(NoiseThresholdsGetRequest request) {
        return get(request, null);
    }

    public NoiseThreshold get(NoiseThresholdsGetRequest request, RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse(this.clientOptions.environment().getUrl())
                .newBuilder()
                .addPathSegments("noise_sensors/noise_thresholds/get")
                .build();
        RequestBody body;
        try {
            body = RequestBody.create(
                    ObjectMappers.JSON_MAPPER.writeValueAsBytes(request), MediaType.parse("application/json"));
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
        Request okhttpRequest = new Request.Builder()
                .url(httpUrl)
                .method("POST", body)
                .headers(Headers.of(clientOptions.headers(requestOptions)))
                .addHeader("Content-Type", "application/json")
                .build();
        try {
            Response response =
                    clientOptions.httpClient().newCall(okhttpRequest).execute();
            if (response.isSuccessful()) {
                NoiseThresholdsGetResponse parsedResponse =
                        ObjectMappers.JSON_MAPPER.readValue(response.body().string(), NoiseThresholdsGetResponse.class);
                return parsedResponse.getNoiseThreshold();
            }
            throw new ApiError(
                    response.code(),
                    ObjectMappers.JSON_MAPPER.readValue(response.body().string(), Object.class));
        } catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public List<NoiseThreshold> list(NoiseThresholdsListRequest request) {
        return list(request, null);
    }

    public List<NoiseThreshold> list(NoiseThresholdsListRequest request, RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse(this.clientOptions.environment().getUrl())
                .newBuilder()
                .addPathSegments("noise_sensors/noise_thresholds/list")
                .build();
        RequestBody body;
        try {
            body = RequestBody.create(
                    ObjectMappers.JSON_MAPPER.writeValueAsBytes(request), MediaType.parse("application/json"));
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
        Request okhttpRequest = new Request.Builder()
                .url(httpUrl)
                .method("POST", body)
                .headers(Headers.of(clientOptions.headers(requestOptions)))
                .addHeader("Content-Type", "application/json")
                .build();
        try {
            Response response =
                    clientOptions.httpClient().newCall(okhttpRequest).execute();
            if (response.isSuccessful()) {
                NoiseThresholdsListResponse parsedResponse = ObjectMappers.JSON_MAPPER.readValue(
                        response.body().string(), NoiseThresholdsListResponse.class);
                return parsedResponse.getNoiseThresholds();
            }
            throw new ApiError(
                    response.code(),
                    ObjectMappers.JSON_MAPPER.readValue(response.body().string(), Object.class));
        } catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public ActionAttempt update(NoiseThresholdsUpdateRequest request) {
        return update(request, null);
    }

    public ActionAttempt update(NoiseThresholdsUpdateRequest request, RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse(this.clientOptions.environment().getUrl())
                .newBuilder()
                .addPathSegments("noise_sensors/noise_thresholds/update")
                .build();
        RequestBody body;
        try {
            body = RequestBody.create(
                    ObjectMappers.JSON_MAPPER.writeValueAsBytes(request), MediaType.parse("application/json"));
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
        Request okhttpRequest = new Request.Builder()
                .url(httpUrl)
                .method("POST", body)
                .headers(Headers.of(clientOptions.headers(requestOptions)))
                .addHeader("Content-Type", "application/json")
                .build();
        try {
            Response response =
                    clientOptions.httpClient().newCall(okhttpRequest).execute();
            if (response.isSuccessful()) {
                NoiseThresholdsUpdateResponse parsedResponse = ObjectMappers.JSON_MAPPER.readValue(
                        response.body().string(), NoiseThresholdsUpdateResponse.class);
                return parsedResponse.getActionAttempt();
            }
            throw new ApiError(
                    response.code(),
                    ObjectMappers.JSON_MAPPER.readValue(response.body().string(), Object.class));
        } catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}
