/*
 * Decompiled with CFR 0.152.
 */
package com.seam.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.seam.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class CurrentClimateSetting {
    private final Optional<Boolean> automaticHeatingEnabled;
    private final Optional<Boolean> automaticCoolingEnabled;
    private final Optional<String> hvacModeSetting;
    private final Optional<Double> coolingSetPointCelsius;
    private final Optional<Double> heatingSetPointCelsius;
    private final Optional<Double> coolingSetPointFahrenheit;
    private final Optional<Double> heatingSetPointFahrenheit;
    private final Optional<Boolean> manualOverrideAllowed;
    private final Map<String, Object> additionalProperties;

    private CurrentClimateSetting(Optional<Boolean> automaticHeatingEnabled, Optional<Boolean> automaticCoolingEnabled, Optional<String> hvacModeSetting, Optional<Double> coolingSetPointCelsius, Optional<Double> heatingSetPointCelsius, Optional<Double> coolingSetPointFahrenheit, Optional<Double> heatingSetPointFahrenheit, Optional<Boolean> manualOverrideAllowed, Map<String, Object> additionalProperties) {
        this.automaticHeatingEnabled = automaticHeatingEnabled;
        this.automaticCoolingEnabled = automaticCoolingEnabled;
        this.hvacModeSetting = hvacModeSetting;
        this.coolingSetPointCelsius = coolingSetPointCelsius;
        this.heatingSetPointCelsius = heatingSetPointCelsius;
        this.coolingSetPointFahrenheit = coolingSetPointFahrenheit;
        this.heatingSetPointFahrenheit = heatingSetPointFahrenheit;
        this.manualOverrideAllowed = manualOverrideAllowed;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="automatic_heating_enabled")
    public Optional<Boolean> getAutomaticHeatingEnabled() {
        return this.automaticHeatingEnabled;
    }

    @JsonProperty(value="automatic_cooling_enabled")
    public Optional<Boolean> getAutomaticCoolingEnabled() {
        return this.automaticCoolingEnabled;
    }

    @JsonProperty(value="hvac_mode_setting")
    public Optional<String> getHvacModeSetting() {
        return this.hvacModeSetting;
    }

    @JsonProperty(value="cooling_set_point_celsius")
    public Optional<Double> getCoolingSetPointCelsius() {
        return this.coolingSetPointCelsius;
    }

    @JsonProperty(value="heating_set_point_celsius")
    public Optional<Double> getHeatingSetPointCelsius() {
        return this.heatingSetPointCelsius;
    }

    @JsonProperty(value="cooling_set_point_fahrenheit")
    public Optional<Double> getCoolingSetPointFahrenheit() {
        return this.coolingSetPointFahrenheit;
    }

    @JsonProperty(value="heating_set_point_fahrenheit")
    public Optional<Double> getHeatingSetPointFahrenheit() {
        return this.heatingSetPointFahrenheit;
    }

    @JsonProperty(value="manual_override_allowed")
    public Optional<Boolean> getManualOverrideAllowed() {
        return this.manualOverrideAllowed;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof CurrentClimateSetting && this.equalTo((CurrentClimateSetting)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CurrentClimateSetting other) {
        return this.automaticHeatingEnabled.equals(other.automaticHeatingEnabled) && this.automaticCoolingEnabled.equals(other.automaticCoolingEnabled) && this.hvacModeSetting.equals(other.hvacModeSetting) && this.coolingSetPointCelsius.equals(other.coolingSetPointCelsius) && this.heatingSetPointCelsius.equals(other.heatingSetPointCelsius) && this.coolingSetPointFahrenheit.equals(other.coolingSetPointFahrenheit) && this.heatingSetPointFahrenheit.equals(other.heatingSetPointFahrenheit) && this.manualOverrideAllowed.equals(other.manualOverrideAllowed);
    }

    public int hashCode() {
        return Objects.hash(this.automaticHeatingEnabled, this.automaticCoolingEnabled, this.hvacModeSetting, this.coolingSetPointCelsius, this.heatingSetPointCelsius, this.coolingSetPointFahrenheit, this.heatingSetPointFahrenheit, this.manualOverrideAllowed);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<Boolean> automaticHeatingEnabled = Optional.empty();
        private Optional<Boolean> automaticCoolingEnabled = Optional.empty();
        private Optional<String> hvacModeSetting = Optional.empty();
        private Optional<Double> coolingSetPointCelsius = Optional.empty();
        private Optional<Double> heatingSetPointCelsius = Optional.empty();
        private Optional<Double> coolingSetPointFahrenheit = Optional.empty();
        private Optional<Double> heatingSetPointFahrenheit = Optional.empty();
        private Optional<Boolean> manualOverrideAllowed = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(CurrentClimateSetting other) {
            this.automaticHeatingEnabled(other.getAutomaticHeatingEnabled());
            this.automaticCoolingEnabled(other.getAutomaticCoolingEnabled());
            this.hvacModeSetting(other.getHvacModeSetting());
            this.coolingSetPointCelsius(other.getCoolingSetPointCelsius());
            this.heatingSetPointCelsius(other.getHeatingSetPointCelsius());
            this.coolingSetPointFahrenheit(other.getCoolingSetPointFahrenheit());
            this.heatingSetPointFahrenheit(other.getHeatingSetPointFahrenheit());
            this.manualOverrideAllowed(other.getManualOverrideAllowed());
            return this;
        }

        @JsonSetter(value="automatic_heating_enabled", nulls=Nulls.SKIP)
        public Builder automaticHeatingEnabled(Optional<Boolean> automaticHeatingEnabled) {
            this.automaticHeatingEnabled = automaticHeatingEnabled;
            return this;
        }

        public Builder automaticHeatingEnabled(Boolean automaticHeatingEnabled) {
            this.automaticHeatingEnabled = Optional.of(automaticHeatingEnabled);
            return this;
        }

        @JsonSetter(value="automatic_cooling_enabled", nulls=Nulls.SKIP)
        public Builder automaticCoolingEnabled(Optional<Boolean> automaticCoolingEnabled) {
            this.automaticCoolingEnabled = automaticCoolingEnabled;
            return this;
        }

        public Builder automaticCoolingEnabled(Boolean automaticCoolingEnabled) {
            this.automaticCoolingEnabled = Optional.of(automaticCoolingEnabled);
            return this;
        }

        @JsonSetter(value="hvac_mode_setting", nulls=Nulls.SKIP)
        public Builder hvacModeSetting(Optional<String> hvacModeSetting) {
            this.hvacModeSetting = hvacModeSetting;
            return this;
        }

        public Builder hvacModeSetting(String hvacModeSetting) {
            this.hvacModeSetting = Optional.of(hvacModeSetting);
            return this;
        }

        @JsonSetter(value="cooling_set_point_celsius", nulls=Nulls.SKIP)
        public Builder coolingSetPointCelsius(Optional<Double> coolingSetPointCelsius) {
            this.coolingSetPointCelsius = coolingSetPointCelsius;
            return this;
        }

        public Builder coolingSetPointCelsius(Double coolingSetPointCelsius) {
            this.coolingSetPointCelsius = Optional.of(coolingSetPointCelsius);
            return this;
        }

        @JsonSetter(value="heating_set_point_celsius", nulls=Nulls.SKIP)
        public Builder heatingSetPointCelsius(Optional<Double> heatingSetPointCelsius) {
            this.heatingSetPointCelsius = heatingSetPointCelsius;
            return this;
        }

        public Builder heatingSetPointCelsius(Double heatingSetPointCelsius) {
            this.heatingSetPointCelsius = Optional.of(heatingSetPointCelsius);
            return this;
        }

        @JsonSetter(value="cooling_set_point_fahrenheit", nulls=Nulls.SKIP)
        public Builder coolingSetPointFahrenheit(Optional<Double> coolingSetPointFahrenheit) {
            this.coolingSetPointFahrenheit = coolingSetPointFahrenheit;
            return this;
        }

        public Builder coolingSetPointFahrenheit(Double coolingSetPointFahrenheit) {
            this.coolingSetPointFahrenheit = Optional.of(coolingSetPointFahrenheit);
            return this;
        }

        @JsonSetter(value="heating_set_point_fahrenheit", nulls=Nulls.SKIP)
        public Builder heatingSetPointFahrenheit(Optional<Double> heatingSetPointFahrenheit) {
            this.heatingSetPointFahrenheit = heatingSetPointFahrenheit;
            return this;
        }

        public Builder heatingSetPointFahrenheit(Double heatingSetPointFahrenheit) {
            this.heatingSetPointFahrenheit = Optional.of(heatingSetPointFahrenheit);
            return this;
        }

        @JsonSetter(value="manual_override_allowed", nulls=Nulls.SKIP)
        public Builder manualOverrideAllowed(Optional<Boolean> manualOverrideAllowed) {
            this.manualOverrideAllowed = manualOverrideAllowed;
            return this;
        }

        public Builder manualOverrideAllowed(Boolean manualOverrideAllowed) {
            this.manualOverrideAllowed = Optional.of(manualOverrideAllowed);
            return this;
        }

        public CurrentClimateSetting build() {
            return new CurrentClimateSetting(this.automaticHeatingEnabled, this.automaticCoolingEnabled, this.hvacModeSetting, this.coolingSetPointCelsius, this.heatingSetPointCelsius, this.coolingSetPointFahrenheit, this.heatingSetPointFahrenheit, this.manualOverrideAllowed, this.additionalProperties);
        }
    }
}

