/*
 * Decompiled with CFR 0.152.
 */
package io.github.sebasbaumh.mapbox.vectortile.adapt.jts;

import io.github.sebasbaumh.mapbox.vectortile.VectorTile;
import io.github.sebasbaumh.mapbox.vectortile.adapt.jts.IUserDataConverter;
import io.github.sebasbaumh.mapbox.vectortile.adapt.jts.JtsAdapter;
import io.github.sebasbaumh.mapbox.vectortile.adapt.jts.UserDataKeyValueMapConverter;
import io.github.sebasbaumh.mapbox.vectortile.adapt.jts.model.JtsLayer;
import io.github.sebasbaumh.mapbox.vectortile.adapt.jts.model.JtsMvt;
import io.github.sebasbaumh.mapbox.vectortile.build.MvtLayerParams;
import io.github.sebasbaumh.mapbox.vectortile.build.MvtLayerProps;
import io.github.sebasbaumh.mapbox.vectortile.util.MvtUtil;
import java.io.IOException;
import java.io.OutputStream;
import javax.annotation.Nullable;
import org.eclipse.jdt.annotation.DefaultLocation;
import org.eclipse.jdt.annotation.NonNullByDefault;

@NonNullByDefault(value={DefaultLocation.PARAMETER, DefaultLocation.RETURN_TYPE})
public final class MvtEncoder {
    @Deprecated
    private MvtEncoder() {
    }

    public static byte[] encode(JtsMvt mvt) {
        return MvtEncoder.encodeToTile(mvt, MvtLayerParams.DEFAULT, new UserDataKeyValueMapConverter()).toByteArray();
    }

    public static byte[] encode(JtsMvt mvt, MvtLayerParams mvtLayerParams, @Nullable IUserDataConverter userDataConverter) {
        return MvtEncoder.encodeToTile(mvt, mvtLayerParams, userDataConverter).toByteArray();
    }

    public static void encodeTo(OutputStream out, JtsMvt mvt, MvtLayerParams mvtLayerParams, @Nullable IUserDataConverter userDataConverter) throws IOException {
        MvtEncoder.encodeToTile(mvt, mvtLayerParams, userDataConverter).writeTo(out);
    }

    public static VectorTile.Tile encodeToTile(JtsMvt mvt, MvtLayerParams mvtLayerParams, @Nullable IUserDataConverter userDataConverter) {
        VectorTile.Tile.Builder tileBuilder = VectorTile.Tile.newBuilder();
        for (JtsLayer layer : mvt.getLayers()) {
            VectorTile.Tile.Layer.Builder layerBuilder = MvtUtil.newLayerBuilder(layer.getName(), mvtLayerParams);
            MvtLayerProps layerProps = new MvtLayerProps();
            JtsAdapter.addFeatures(layerBuilder, layer.getGeometries(), layerProps, userDataConverter);
            MvtUtil.writeProps(layerBuilder, layerProps);
            tileBuilder.addLayers(layerBuilder.build());
        }
        return tileBuilder.build();
    }
}

