/*
 * Decompiled with CFR 0.152.
 */
package io.github.sebasbaumh.mapbox.vectortile.adapt.jts;

import io.github.sebasbaumh.mapbox.vectortile.VectorTile;
import io.github.sebasbaumh.mapbox.vectortile.adapt.jts.IUserDataConverter;
import io.github.sebasbaumh.mapbox.vectortile.build.MvtLayerProps;
import java.util.Map;
import javax.annotation.Nullable;
import org.eclipse.jdt.annotation.DefaultLocation;
import org.eclipse.jdt.annotation.NonNullByDefault;

@NonNullByDefault(value={DefaultLocation.PARAMETER, DefaultLocation.RETURN_TYPE})
public class UserDataKeyValueMapConverter
implements IUserDataConverter {
    @Nullable
    private final String idKey;

    public UserDataKeyValueMapConverter() {
        this.idKey = null;
    }

    public UserDataKeyValueMapConverter(String idKey) {
        this.idKey = idKey;
    }

    @Override
    public void addTags(Object userData, MvtLayerProps layerProps, VectorTile.Tile.Feature.Builder featureBuilder) {
        try {
            Object idValue;
            Map userDataMap = (Map)userData;
            for (Map.Entry e : userDataMap.entrySet()) {
                int valueIndex;
                String key = (String)e.getKey();
                Object value = e.getValue();
                if (key == null || value == null || (valueIndex = layerProps.addValue(value)) < 0) continue;
                featureBuilder.addTags(layerProps.addKey(key));
                featureBuilder.addTags(valueIndex);
            }
            if (this.idKey != null && (idValue = userDataMap.get(this.idKey)) != null) {
                if (idValue instanceof Long || idValue instanceof Integer || idValue instanceof Float || idValue instanceof Double || idValue instanceof Byte || idValue instanceof Short) {
                    featureBuilder.setId((Long)idValue);
                } else if (idValue instanceof String) {
                    try {
                        featureBuilder.setId(Long.parseLong((String)idValue));
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
            }
        }
        catch (ClassCastException ex) {
            throw new IllegalArgumentException("unsupported user data: " + userData, ex);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [idKey=" + this.idKey + "]";
    }
}

