/*
 * Decompiled with CFR 0.152.
 */
package io.github.sebasbaumh.mapbox.vectortile.build;

import org.eclipse.jdt.annotation.DefaultLocation;
import org.eclipse.jdt.annotation.NonNullByDefault;

@NonNullByDefault(value={DefaultLocation.PARAMETER, DefaultLocation.RETURN_TYPE})
public class MvtLayerParams {
    public static final int DEFAULT_EXTENT = 4096;
    public static final MvtLayerParams DEFAULT = new MvtLayerParams(4096);
    private final int extent;

    @Deprecated
    public MvtLayerParams() {
        this(4096);
    }

    public MvtLayerParams(int extent) {
        if (extent <= 0) {
            throw new IllegalArgumentException("extent must be > 0");
        }
        this.extent = extent;
    }

    public int getExtent() {
        return this.extent;
    }

    public double getRatio() {
        return (double)this.extent / 256.0;
    }

    public int getTileSize() {
        return 256;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [tileSize=" + this.getTileSize() + ", extent=" + this.getExtent() + ", ratio=" + this.getRatio() + "]";
    }
}

