/*
 * Decompiled with CFR 0.152.
 */
package io.github.sebasbaumh.mapbox.vectortile.build;

import io.github.sebasbaumh.mapbox.vectortile.util.MvtUtil;
import java.util.LinkedHashMap;
import java.util.Objects;
import org.eclipse.jdt.annotation.DefaultLocation;
import org.eclipse.jdt.annotation.NonNullByDefault;

@NonNullByDefault(value={DefaultLocation.PARAMETER, DefaultLocation.RETURN_TYPE})
public class MvtLayerProps {
    private final LinkedHashMap<String, Integer> keys = new LinkedHashMap();
    private final LinkedHashMap<Object, Integer> values = new LinkedHashMap();

    public int addKey(String key) {
        Objects.requireNonNull(key);
        int nextIndex = this.keys.size();
        Integer mapIndex = this.keys.putIfAbsent(key, nextIndex);
        return mapIndex == null ? nextIndex : mapIndex;
    }

    public int addValue(Object value) {
        Objects.requireNonNull(value);
        if (!MvtUtil.isValidPropValue(value)) {
            return -1;
        }
        int nextIndex = this.values.size();
        Integer mapIndex = this.values.putIfAbsent(value, nextIndex);
        return mapIndex == null ? nextIndex : mapIndex;
    }

    public Iterable<String> getKeys() {
        return this.keys.keySet();
    }

    public Iterable<Object> getValues() {
        return this.values.keySet();
    }

    public String toString() {
        return "MvtLayerProps [keys=" + this.keys + ", values=" + this.values + "]";
    }
}

