/*
 * Decompiled with CFR 0.152.
 */
package io.github.sebasbaumh.mapbox.vectortile.util;

import io.github.sebasbaumh.mapbox.vectortile.VectorTile;
import io.github.sebasbaumh.mapbox.vectortile.adapt.jts.JtsAdapter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.annotation.DefaultLocation;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;

@NonNullByDefault(value={DefaultLocation.PARAMETER, DefaultLocation.RETURN_TYPE})
public final class JtsGeomStats {
    public final Map<VectorTile.Tile.GeomType, Integer> featureCounts;
    public final List<FeatureStats> featureStats = new ArrayList<FeatureStats>();

    private JtsGeomStats() {
        VectorTile.Tile.GeomType[] geomTypes = VectorTile.Tile.GeomType.values();
        this.featureCounts = new HashMap<VectorTile.Tile.GeomType, Integer>(geomTypes.length);
        for (VectorTile.Tile.GeomType nextGeomType : geomTypes) {
            this.featureCounts.put(nextGeomType, 0);
        }
    }

    private static int checkRepeatedPoints2d(LineString lineString) {
        int repeatedPoints = 0;
        CoordinateSequence coordSeq = lineString.getCoordinateSequence();
        Coordinate nextCoord = null;
        for (int i = 0; i < coordSeq.size(); ++i) {
            Coordinate prevCoord = nextCoord;
            nextCoord = coordSeq.getCoordinate(i);
            if (!nextCoord.equals((Object)prevCoord)) continue;
            ++repeatedPoints;
        }
        return repeatedPoints;
    }

    private static FeatureStats getStats(Geometry geom, VectorTile.Tile.GeomType type) {
        switch (type) {
            case POINT: {
                return JtsGeomStats.pointStats(geom);
            }
            case LINESTRING: {
                return JtsGeomStats.lineStats(geom);
            }
            case POLYGON: {
                return JtsGeomStats.polyStats(geom);
            }
        }
        return new FeatureStats();
    }

    public static JtsGeomStats getStats(Iterable<Geometry> flatGeomList) {
        JtsGeomStats stats = new JtsGeomStats();
        for (Geometry nextGeom : flatGeomList) {
            VectorTile.Tile.GeomType geomType = JtsAdapter.toGeomType(nextGeom);
            Integer value = stats.featureCounts.get((Object)geomType);
            value = value == null ? 1 : value + 1;
            stats.featureCounts.put(geomType, value);
            stats.featureStats.add(JtsGeomStats.getStats(nextGeom, geomType));
        }
        return stats;
    }

    private static FeatureStats lineStats(Geometry geom) {
        FeatureStats featureStats = new FeatureStats();
        for (int i = 0; i < geom.getNumGeometries(); ++i) {
            LineString lineString = (LineString)geom.getGeometryN(i);
            featureStats.totalPts += lineString.getNumPoints();
            featureStats.repeatedPts += JtsGeomStats.checkRepeatedPoints2d(lineString);
        }
        return featureStats;
    }

    private static FeatureStats pointStats(Geometry geom) {
        FeatureStats featureStats = new FeatureStats();
        HashSet<Point> pointSet = new HashSet<Point>(geom.getNumPoints());
        featureStats.totalPts = geom.getNumPoints();
        for (int i = 0; i < geom.getNumGeometries(); ++i) {
            Point p = (Point)geom.getGeometryN(i);
            featureStats.repeatedPts = featureStats.repeatedPts + (pointSet.add(p) ? 0 : 1);
        }
        return featureStats;
    }

    private static FeatureStats polyStats(Geometry geom) {
        FeatureStats featureStats = new FeatureStats();
        for (int i = 0; i < geom.getNumGeometries(); ++i) {
            Polygon nextPoly = (Polygon)geom.getGeometryN(i);
            LinearRing exteriorRing = nextPoly.getExteriorRing();
            featureStats.totalPts += exteriorRing.getNumPoints();
            featureStats.repeatedPts += JtsGeomStats.checkRepeatedPoints2d((LineString)exteriorRing);
            for (int ringIndex = 0; ringIndex < nextPoly.getNumInteriorRing(); ++ringIndex) {
                LinearRing nextInteriorRing = nextPoly.getInteriorRingN(ringIndex);
                featureStats.totalPts += nextInteriorRing.getNumPoints();
                featureStats.repeatedPts += JtsGeomStats.checkRepeatedPoints2d((LineString)nextInteriorRing);
            }
        }
        return featureStats;
    }

    public String toString() {
        return "JtsGeomStats{featureCounts=" + this.featureCounts + ", featureStats=" + this.featureStats + "}";
    }

    public static final class FeatureStats {
        public int repeatedPts;
        public int totalPts;

        public String toString() {
            return "FeatureStats{totalPts=" + this.totalPts + ", repeatedPts=" + this.repeatedPts + "}";
        }
    }
}

