/*
 * Decompiled with CFR 0.152.
 */
package io.github.sercasti.tracing.core;

import io.github.sercasti.tracing.core.Metric;
import io.github.sercasti.tracing.core.Tracing;
import jakarta.servlet.http.HttpServletResponse;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class TracingImpl
implements Tracing {
    private static final String SERVER_TIMING_HEADER_DUR = "dur=";
    private static final String SERVER_TIMING_HEADER_DESC = "desc=";
    final List<Metric> metrics = new ArrayList<Metric>();

    @Override
    public Metric start(String name, String description) {
        Metric metric = new Metric(name, description);
        this.metrics.add(metric);
        return metric;
    }

    public void dump(HttpServletResponse response, String chainingHeaders) {
        String content = this.metrics.stream().map(m -> this.convert((Metric)m)).reduce("", (metrica, metricb) -> metrica + "," + metricb);
        String union = Stream.of(chainingHeaders, content.substring(1)).filter(s -> s != null && !s.isEmpty()).collect(Collectors.joining(" "));
        if (union.length() > 0) {
            response.addHeader("Server-Timing", union);
        }
        this.metrics.clear();
    }

    String convert(Metric metric) {
        Duration duration = metric.getDuration();
        String description = metric.getDescription();
        String durPart = Optional.ofNullable(duration).map(d -> ";dur=" + Math.max(1.0, (double)d.toNanos()) / 1000000.0).orElse("");
        String descPart = Optional.ofNullable(description).map(d -> ";desc=\"" + d + "\"").orElse("");
        return metric.getName() + descPart + durPart;
    }
}

