/*
 * Decompiled with CFR 0.152.
 */
package io.github.seujorgenochurras.domain.manager;

import io.github.seujorgenochurras.domain.Dependency;
import io.github.seujorgenochurras.domain.Plugin;
import io.github.seujorgenochurras.mapper.DependencyManagerFile;
import io.github.seujorgenochurras.utils.FileUtils;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.List;

public class GradleBuildFile
implements DependencyManagerFile {
    private List<Dependency> dependencies;
    private List<Plugin> plugins;
    private File originFile;
    private String originFileAsString;
    private FileWriter fileWriter;

    @Override
    public List<Dependency> getDependencies() {
        return this.dependencies;
    }

    @Override
    public List<Plugin> getPlugins() {
        return this.plugins;
    }

    public GradleBuildFile setPlugins(List<Plugin> plugins) {
        this.plugins = plugins;
        return this;
    }

    public File getOriginFile() {
        return this.originFile;
    }

    GradleBuildFile setOriginFile(File originFile) {
        this.originFile = originFile;
        this.originFileAsString = FileUtils.getFileAsString(originFile);
        return this;
    }

    public FileWriter getFileWriter() {
        if (this.fileWriter == null) {
            this.fileWriter = this.tryInstantiateFileWriterFromFile(this.originFile);
        }
        return this.fileWriter;
    }

    private FileWriter tryInstantiateFileWriterFromFile(File file) {
        try {
            return new FileWriter(file);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public GradleBuildFile setDependencies(List<Dependency> dependencies) {
        this.dependencies = dependencies;
        return this;
    }

    @Override
    public void addDependency(Dependency gradleDependency) {
        String declaration = "\n implementation \"" + gradleDependency.getGroupName().trim() + ":" + gradleDependency.getArtifact().trim() + ":" + gradleDependency.getVersion().trim() + "\"";
        this.addTextToOriginFile(declaration, this.getIndexOfBlock("dependencies"));
        this.tryRewriteOriginFile();
    }

    @Override
    public void addPlugin(Plugin plugin) {
        String declaration = "\n id '" + plugin.getId().trim() + "'";
        this.addTextToOriginFile(declaration, this.getIndexOfBlock("plugins"));
        this.tryRewriteOriginFile();
    }

    private void addTextToOriginFile(String text, int indexOfWhereToWrite) {
        String secondOriginFileHalf = text + this.originFileAsString.substring(indexOfWhereToWrite);
        this.originFileAsString = this.originFileAsString.substring(0, indexOfWhereToWrite) + secondOriginFileHalf;
    }

    private void tryRewriteOriginFile() {
        try {
            this.getFileWriter().write(this.originFileAsString);
            this.getFileWriter().close();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    private int getIndexOfBlock(String blockName) {
        int dependenciesStringLength = blockName.length();
        return FileUtils.getFileAsString(this.originFile).lastIndexOf(blockName) + dependenciesStringLength;
    }

    public String toString() {
        return "GradleBuildFile{plugins=" + String.valueOf(this.plugins) + ", dependencies=" + String.valueOf(this.dependencies) + "}";
    }
}

