/*
 * Decompiled with CFR 0.152.
 */
package io.github.seujorgenochurras.domain.manager;

import io.github.seujorgenochurras.domain.AbstractPlugin;
import io.github.seujorgenochurras.domain.PluginDeclaration;
import io.github.seujorgenochurras.domain.dependency.Dependency;
import io.github.seujorgenochurras.domain.dependency.DependencyDeclaration;
import io.github.seujorgenochurras.mapper.DependencyManagerFile;
import io.github.seujorgenochurras.utils.FileUtils;
import io.github.seujorgenochurras.utils.StringUtils;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;

public class GradleBuildFile
implements DependencyManagerFile {
    private List<DependencyDeclaration> dependencies;
    private List<PluginDeclaration> plugins;
    private File originFile;
    private String originFileAsString;
    private FileWriter fileWriter;

    @Override
    public List<Dependency> getDependencies() {
        return this.dependencies.stream().map(DependencyDeclaration::toDependencyObject).collect(Collectors.toList());
    }

    public List<AbstractPlugin> getPlugins() {
        return this.plugins.stream().map(PluginDeclaration::toPluginObject).toList();
    }

    public void setPlugins(List<PluginDeclaration> plugins) {
        this.plugins = plugins;
    }

    public void setDependencies(List<DependencyDeclaration> dependencies) {
        this.dependencies = dependencies;
    }

    public File getOriginFile() {
        return this.originFile;
    }

    public void setOriginFile(File originFile) {
        this.originFile = originFile;
        this.originFileAsString = FileUtils.getFileAsString(originFile);
    }

    public FileWriter getFileWriter() {
        if (this.fileWriter == null) {
            this.fileWriter = this.tryInstantiateFileWriterFromFile(this.originFile);
        }
        return this.fileWriter;
    }

    @Override
    public void addDependency(Dependency dependency) {
        String declaration = "\n" + dependency.getDependencyType().typeName + " (\"" + dependency.getGroupName().trim() + ":" + dependency.getArtifact().trim() + ":" + dependency.getVersion().trim() + "\")";
        int indexOfDependenciesBlock = this.getIndexOfDependenciesBlock();
        this.addTextToOriginFile(declaration, indexOfDependenciesBlock);
        this.tryRewriteOriginFile();
        this.dependencies.add(new DependencyDeclaration(declaration, indexOfDependenciesBlock));
    }

    @Override
    public <T extends AbstractPlugin> void addPlugin(T plugin) {
        String declaration = "id '" + plugin.getId().trim() + "'\n";
        int indexOfPluginBlock = StringUtils.getIndexOfStringWithRegex(this.originFileAsString, "plugins");
        this.addTextToOriginFile(declaration, indexOfPluginBlock);
        this.tryRewriteOriginFile();
        this.plugins.add(new PluginDeclaration(declaration, indexOfPluginBlock));
    }

    private int getIndexOfDependenciesBlock() {
        return StringUtils.getIndexOfStringWithRegex(this.originFileAsString, "dependencies.*\\{");
    }

    private void addTextToOriginFile(String text, int indexOfWhereToWrite) {
        String secondOriginFileHalf = text + this.originFileAsString.substring(indexOfWhereToWrite);
        this.originFileAsString = this.originFileAsString.substring(0, indexOfWhereToWrite) + secondOriginFileHalf;
    }

    private void tryRewriteOriginFile() {
        try (FileWriter originFileWriter = this.getFileWriter();){
            originFileWriter.write(this.originFileAsString);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    private FileWriter tryInstantiateFileWriterFromFile(File file) {
        try {
            return new FileWriter(file);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public String toString() {
        return "GradleBuildFile{plugins=" + String.valueOf(this.plugins) + ", dependencies=" + String.valueOf(this.dependencies) + "}";
    }
}

