/*
 * Decompiled with CFR 0.152.
 */
package io.github.seujorgenochurras.file;

import io.github.seujorgenochurras.file.SearchPlaces;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.Supplier;

public class FileSearcher {
    private final String searchPath;
    private final List<String> filesNameToSearch = new ArrayList<String>();
    private Supplier<? extends RuntimeException> notFoundSupplier = () -> new NoSuchElementException("File not found");

    private FileSearcher(SearchPlaces searchPlace) {
        this.searchPath = searchPlace.placePath;
    }

    public FileSearcher(String searchPath) {
        this.searchPath = searchPath;
    }

    public static FileSearcher searchIn(SearchPlaces searchPlace) {
        return new FileSearcher(searchPlace);
    }

    public static FileSearcher searchForFile(String fileName) {
        FileSearcher fileSearcher = new FileSearcher(SearchPlaces.PROJECT_ROOT);
        return fileSearcher.addFileToSearch(fileName);
    }

    private FileSearcher addFileToSearch(String fileNameAndPath) {
        this.filesNameToSearch.add(fileNameAndPath);
        return this;
    }

    public FileSearcher ifNotFoundSearchFor(String fileName) {
        return this.addFileToSearch(this.searchPath + "/" + fileName);
    }

    private File searchFile(String fileNameAndPath) {
        return new File(fileNameAndPath);
    }

    public File getSearchResult() {
        File fileFound = null;
        for (String fileNameAndPath : this.filesNameToSearch) {
            if (!Objects.isNull(fileFound)) break;
            fileFound = this.searchFile(fileNameAndPath);
        }
        if (Objects.isNull(fileFound)) {
            throw this.notFoundSupplier.get();
        }
        return fileFound;
    }

    public <T extends RuntimeException> FileSearcher ifNotFoundThrow(Supplier<T> notFoundSupplier) {
        this.notFoundSupplier = notFoundSupplier;
        return this;
    }
}

