/*
 * Decompiled with CFR 0.152.
 */
package io.github.seujorgenochurras.manager;

import io.github.seujorgenochurras.file.DependencyFileNotFoundException;
import io.github.seujorgenochurras.file.FileSearcher;
import io.github.seujorgenochurras.mapper.DependencyManagerFile;
import io.github.seujorgenochurras.mapper.DependencyMapper;
import io.github.seujorgenochurras.utils.StringUtils;
import java.io.File;

public class DependencyManager {
    private DependencyManager() {
    }

    public static DependencyManagerFile getDependencyManagerFile(String filePath) {
        if (StringUtils.lastCharOfString(filePath) != '/') {
            filePath = filePath.concat("/");
        }
        return DependencyMapper.mapFile(DependencyManager.getDependencyManagerAsFile(filePath));
    }

    public static DependencyManagerFile getDependencyManagerFile() {
        return DependencyManager.getDependencyManagerFile(System.getProperty("user.dir"));
    }

    private static File getDependencyManagerAsFile(String path) {
        return FileSearcher.searchForFileIn("build.gradle", path).ifNotFoundSearchFor("build.gradle.kts").ifNotFoundSearchFor("pom.xml").ifNotFoundThrow(() -> new DependencyFileNotFoundException("No dependency manager file found")).getSearchResult();
    }
}

