/*
 * Decompiled with CFR 0.152.
 */
package io.github.seujorgenochurras.domain.dependency;

import io.github.seujorgenochurras.domain.dependency.DependencyTypeNotFoundException;

public enum DependencyType {
    TEST_IMPLEMENTATION("testImplementation"),
    TEST_RUNTIME_ONLY("testRuntimeOnly"),
    TEST_COMPILE_ONLY("testCompileOnly"),
    RUNTIME_ONLY("runtimeOnly"),
    IMPLEMENTATION("implementation"),
    API("api"),
    COMPILE_ONLY("compileOnly"),
    COMPILE_ONLY_API("compileOnlyApi");

    public final String typeName;

    private DependencyType(String typeName) {
        this.typeName = typeName;
    }

    public static DependencyType getTypeByName(String typeName) {
        for (DependencyType type : DependencyType.values()) {
            if (!type.typeName.equals(typeName.trim())) continue;
            return type;
        }
        throw new DependencyTypeNotFoundException("Dependency type \"" + typeName + "\" not found");
    }
}

