/*
 * Decompiled with CFR 0.152.
 */
package io.github.seujorgenochurras.mapper.gradlew;

import io.github.seujorgenochurras.domain.PluginDeclaration;
import io.github.seujorgenochurras.domain.dependency.DependencyDeclaration;
import io.github.seujorgenochurras.domain.manager.gradlew.GradleBuildFileBuilder;
import io.github.seujorgenochurras.mapper.DependencyManagerFile;
import io.github.seujorgenochurras.mapper.DependencyMapper;
import io.github.seujorgenochurras.utils.FileUtils;
import io.github.seujorgenochurras.utils.StringUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;

public class GradleMapper
extends DependencyMapper {
    private List<DependencyDeclaration> dependencyDeclarations = new ArrayList<DependencyDeclaration>();
    private List<PluginDeclaration> pluginDeclarations = new ArrayList<PluginDeclaration>();
    protected String gradleBuildFileAsString;

    public GradleMapper(File rootFile) {
        super(rootFile);
        this.gradleBuildFileAsString = FileUtils.getFileAsString(rootFile);
    }

    @Override
    protected DependencyManagerFile map() {
        this.removeComments();
        this.mapDependencies();
        this.mapPlugins();
        return GradleBuildFileBuilder.startBuild().dependenciesDeclaration(this.dependencyDeclarations).plugins(this.pluginDeclarations).originFile(this.rootFile).getBuild();
    }

    @Override
    protected void mapDependencies() {
        this.dependencyDeclarations = this.getDependencyDeclarations();
    }

    @Override
    protected void mapPlugins() {
        this.pluginDeclarations = this.getAllPluginDeclarations();
    }

    private void removeComments() {
        String multiLineAndInLineCommentsRegex = "/\\*((.|\\n)*?)\\*/|//.*";
        this.gradleBuildFileAsString = this.gradleBuildFileAsString.replaceAll(multiLineAndInLineCommentsRegex, "");
    }

    protected List<PluginDeclaration> getAllPluginDeclarations() {
        ArrayList<PluginDeclaration> pluginsAsString = new ArrayList<PluginDeclaration>();
        this.getLinesOfPluginsBlock().forEach((lineNumber, line) -> {
            String pluginDeclarationRegex = "(?<=id).*['\"]";
            Matcher matcher = StringUtils.generateStringMatcherFromRegex(line, pluginDeclarationRegex);
            StringUtils.getAllMatchesOfMatcher(matcher).forEach((pluginDeclarationLine, pluginDeclaration) -> pluginsAsString.add(new PluginDeclaration((String)pluginDeclaration, (int)pluginDeclarationLine)));
        });
        return pluginsAsString;
    }

    protected List<DependencyDeclaration> getDependencyDeclarations() {
        ArrayList<DependencyDeclaration> dependenciesAsString = new ArrayList<DependencyDeclaration>();
        this.getLinesOfDependenciesBlock().forEach((lineNumber, line) -> {
            String dependencyDeclarationRegex = "(testImplementation|implementation|runtime_only|testRuntimeOnly).*".trim();
            Matcher dependencyDeclarationMatcher = StringUtils.generateStringMatcherFromRegex(line, dependencyDeclarationRegex);
            StringUtils.getAllMatchesOfMatcher(dependencyDeclarationMatcher).forEach((dependencyDeclarationLineNumber, dependencyDeclarationLine) -> dependenciesAsString.add(new DependencyDeclaration((String)dependencyDeclarationLine, (int)dependencyDeclarationLineNumber)));
        });
        return dependenciesAsString;
    }

    protected HashMap<Integer, String> getBlockLinesFromGradleFile(String blockName) {
        String blockRegex = StringUtils.generateRegexForCodeBlock(blockName);
        Matcher matcher = this.generateGradleMatcherFromRegex(blockRegex);
        return StringUtils.getAllMatchesOfMatcher(matcher);
    }

    private Matcher generateGradleMatcherFromRegex(String regex) {
        return StringUtils.generateStringMatcherFromRegex(this.gradleBuildFileAsString, regex);
    }

    private HashMap<Integer, String> getLinesOfDependenciesBlock() {
        return this.getBlockLinesFromGradleFile("dependencies");
    }

    private HashMap<Integer, String> getLinesOfPluginsBlock() {
        return this.getBlockLinesFromGradleFile("plugins");
    }
}

