/*
 * Decompiled with CFR 0.152.
 */
package io.github.seujorgenochurras.mapper.maven;

import io.github.seujorgenochurras.domain.AbstractPlugin;
import io.github.seujorgenochurras.domain.dependency.Dependency;
import io.github.seujorgenochurras.domain.dependency.DependencyBuilder;
import io.github.seujorgenochurras.domain.manager.maven.MavenBuildFileBuilder;
import io.github.seujorgenochurras.mapper.DependencyManagerFile;
import io.github.seujorgenochurras.mapper.DependencyMapper;
import io.github.seujorgenochurras.utils.BetterNodeList;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class MavenPomMapper
extends DependencyMapper {
    private static final Logger logger = Logger.getLogger(MavenPomMapper.class.getName());
    private Document pomFileDocument;
    private List<Dependency> dependencies = new ArrayList<Dependency>();
    private final List<AbstractPlugin> plugins = new ArrayList<AbstractPlugin>();

    public MavenPomMapper(File rootFile) {
        super(rootFile);
    }

    @Override
    protected DependencyManagerFile map() {
        this.tryInitPomFileDocument();
        this.mapDependencies();
        this.mapPlugins();
        return MavenBuildFileBuilder.startBuild().rootFile(this.rootFile).dependencies(this.dependencies).plugins(this.plugins).getBuildResult();
    }

    @Override
    protected void mapDependencies() {
        this.dependencies = this.getMavenFileDependencies();
    }

    @Override
    protected void mapPlugins() {
    }

    private List<Dependency> getMavenFileDependencies() {
        BetterNodeList dependencyNodeList = new BetterNodeList(this.getDependencyNodeList());
        ArrayList<Dependency> dependenciesFound = new ArrayList<Dependency>();
        dependencyNodeList.forEachChild(childNode -> {
            BetterNodeList childNodes = new BetterNodeList(childNode.getChildNodes());
            String artifact = childNodes.getChildNodeByName("artifactId").getTextContent();
            String groupName = childNodes.getChildNodeByName("groupId").getTextContent();
            Node versionNode = childNodes.getChildNodeByName("version");
            String version = versionNode == null ? "" : versionNode.getTextContent();
            dependenciesFound.add(DependencyBuilder.startBuild().artifact(artifact).group(groupName).version(version).buildResult());
        });
        return dependenciesFound;
    }

    private NodeList getDependencyNodeList() {
        return this.pomFileDocument.getElementsByTagName("dependency");
    }

    private void tryInitPomFileDocument() {
        try {
            this.initPomFileDocument();
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            logger.severe(e.getMessage());
            e.printStackTrace();
        }
    }

    private void initPomFileDocument() throws ParserConfigurationException, IOException, SAXException {
        DocumentBuilder documentBuilder = DocumentBuilderFactory.newDefaultInstance().newDocumentBuilder();
        this.pomFileDocument = documentBuilder.parse(this.rootFile);
    }
}

