/*
 * Decompiled with CFR 0.152.
 */
package io.github.seujorgenochurras.utils;

import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class BetterNodeList {
    private final NodeList rootNodeList;

    public BetterNodeList(NodeList rootNodeList) {
        this.rootNodeList = rootNodeList;
    }

    public void forEachChild(Consumer<Node> action) {
        if (this.rootNodeList.getLength() < 0) {
            throw new IllegalStateException("Node list cannot be empty");
        }
        for (int i = 0; i < this.rootNodeList.getLength() - 1; ++i) {
            action.accept(this.rootNodeList.item(i));
        }
    }

    public Node getChildNodeByName(String childNodeName) {
        AtomicReference nodeFound = new AtomicReference();
        this.forEachChild(node -> {
            if (node.getNodeName().equals(childNodeName)) {
                nodeFound.set(node);
            }
        });
        return (Node)nodeFound.get();
    }

    public NodeList getRootNodeList() {
        return this.rootNodeList;
    }
}

