package com.plugins.junk;

import com.android.build.gradle.AppExtension;
import com.android.build.gradle.BaseExtension;
import com.android.build.gradle.LibraryExtension;
import com.plugins.junk.utils.LogUtil;

import org.apache.commons.io.FileUtils;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class CodePlugin implements Plugin<Project> {
    private final Map<String, String> mMap = new HashMap<>();

    @Override
    public void apply(Project project) {
        CodeExtension.create(project);
        deleteCache(project);
        executeJarTask(project);
        initConfig(project);
    }

    private void executeJarTask(Project project) {
        project.afterEvaluate(new Action<Project>() {
            @Override
            public void execute(Project p) {
                LogUtil.log("Gradle配置阶段结束");
                if (project.getPlugins().hasPlugin("com.android.application")) {
                    AppExtension app = project.getExtensions().getByType(AppExtension.class);
                    app.getApplicationVariants().all(applicationVariant -> {
                        getJarPath(applicationVariant.getName(), project);
                    });
                } else {
                    LibraryExtension library = project.getExtensions().getByType(LibraryExtension.class);
                    library.getLibraryVariants().all(libraryVariant -> {
                        getJarPath(libraryVariant.getName(), project);
                    });
                }
            }
        });
    }

    private void initConfig(Project project) {
        Object obj = project.getExtensions().findByName(CodeExtension.NAME);
        LogUtil.log("initConfig");
        if (null != obj) {
            CodeExtension extension = (CodeExtension) obj;
            LogUtil.log("registerTransform");
            //AppExtension对应build.gradle中android{...}
            try {
                BaseExtension android = project.getExtensions().getByType(BaseExtension.class);
                //注册一个Transform
                CodeTransform codeTransform = new CodeTransform(project, extension, mMap);
                android.registerTransform(codeTransform);
            } catch (Exception e) {
                LogUtil.error("registerTransform fail: ");
                e.printStackTrace();
            }
        }
    }


    private void deleteCache(Project project) {
        try {//删除缓存代码，防止累加插入
            FileUtils.deleteDirectory(new File(project.getBuildDir(), "/intermediates/transforms/"));
            FileUtils.deleteDirectory(new File(project.getBuildDir(), "/kotlin/compileDebugKotlin/cacheable/"));
        } catch (IOException ignored) {
        }
    }

    private void getJarPath(String name, Project project) {
        if (!mMap.isEmpty())
            return;
        try {
            Configuration runtimeClasspath = project.getConfigurations().getByName(name + "RuntimeClasspath");
            for (File r : runtimeClasspath.getFiles()) {
//                LogUtil.log("jar  name:%s , path:%s", r.getName(), r.getAbsolutePath());
                mMap.put(r.getName(), r.getAbsolutePath());
            }
        } catch (Exception e) {
            getImplementation(project);
        }
//        LogUtil.log("jar  size:" + mMap.size());

    }

    private void getImplementation(Project project) {
        File jarFile = new File(project.getGradle().getGradleUserHomeDir(), "caches" + File.separator + "modules-2" + File.separator + "files-2.1" + File.separator);
        try {
            Configuration implementation = project.getConfigurations().getByName("implementation");
            for (Dependency r : implementation.getAllDependencies()) {
                String version = r.getVersion();
                if (version == null || "unspecified".equals(version)) {
                    continue;
                }
                File file = new File(jarFile, r.getGroup() + File.separator + r.getName() + File.separator + version + File.separator);
                findJar(file);
            }
        } catch (Exception ignored) {
        }
    }

    private void findJar(File files) {
        try {
            File[] listed = files.listFiles();
            if (listed == null)
                return;
            for (File listFile : listed) {
                if (listFile.isDirectory()) {
                    findJar(listFile);
                } else if (listFile.isFile()) {
                    String absolutePath = listFile.getAbsolutePath();
                    if (absolutePath.endsWith(".jar") || absolutePath.endsWith(".aar")) {
//                        LogUtil.log("implementation  name:%s , path:%s", listFile.getName(), listFile.getAbsolutePath());
                        mMap.put(listFile.getName(), listFile.getAbsolutePath());
                    }
                }
            }
        } catch (Exception ignored) {
        }
    }


}
