package com.plugins.junk;

import com.android.build.api.transform.DirectoryInput;
import com.android.build.api.transform.Format;
import com.android.build.api.transform.JarInput;
import com.android.build.api.transform.QualifiedContent;
import com.android.build.api.transform.Transform;
import com.android.build.api.transform.TransformException;
import com.android.build.api.transform.TransformInput;
import com.android.build.api.transform.TransformInvocation;
import com.android.build.gradle.internal.pipeline.TransformManager;
import com.plugins.junk.utils.LogUtil;
import com.plugins.junk.utils.MD5Util;

import org.apache.commons.io.FileUtils;
import org.gradle.api.Project;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class CodeTransform extends Transform {

    private Project mProject;
    private CodeExtension mExtension;
    private CodeInjectUtil codeInjectUtil = new CodeInjectUtil();
    private Map<String, String> mMap;

    public CodeTransform(Project project, CodeExtension extension, Map<String, String> map) {
        mProject = project;
        mExtension = extension;
        mMap = map;
    }


    @Override
    public String getName() {
        return CodeTransform.class.getSimpleName();
    }

    //输入类型，这里只处理class文件
    @Override
    public Set<QualifiedContent.ContentType> getInputTypes() {
        return TransformManager.CONTENT_CLASS;
    }

    @Override
    public Set<? super QualifiedContent.Scope> getScopes() {
        return TransformManager.PROJECT_ONLY;
    }

    @Override
    public boolean isIncremental() {
        return false;
    }

    @Override
    public void transform(TransformInvocation transformInvocation) throws TransformException, InterruptedException, IOException {
        super.transform(transformInvocation);
        LogUtil.log("---- code transform start ----");
        LogUtil.log("code inject enable：" + mExtension.codeInjectEnable);

        //TransformInput有两种类型 一种目录  一种jar  需要分开遍历
        Iterator<TransformInput> inputIterator = transformInvocation.getInputs().iterator();
        //1.拿到输入路径
        while (inputIterator.hasNext()) {
            TransformInput input = inputIterator.next();
            Iterator<DirectoryInput> directoryInputIterator = input.getDirectoryInputs().iterator();
            while (directoryInputIterator.hasNext()) {
                DirectoryInput directoryInput = directoryInputIterator.next();
                if (mExtension.codeInjectEnable) {
                    try {
                        //2. 处理要插入代码的文件
                        codeInjectUtil.injectCode(directoryInput.getFile(), mProject, mExtension,mMap);
                    } catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                //3.将input的目录复制到output指定目录 否则运行时会报ClassNotFound异常
                File contentLocation = transformInvocation.getOutputProvider().getContentLocation(directoryInput.getName(), directoryInput.getContentTypes(),
                        directoryInput.getScopes(), Format.DIRECTORY);
                LogUtil.log("Class文件输入路径 = " + directoryInput.getFile().getAbsolutePath());
                LogUtil.log("Class文件输出路径 = " + contentLocation.getAbsolutePath());

                FileUtils.copyDirectory(directoryInput.getFile(), contentLocation);

            }
            //不处理jar文件，但也要拷贝到transform文件夹
            Iterator<JarInput> jarIterator1 = input.getJarInputs().iterator();
            while (jarIterator1.hasNext()) {
                JarInput jarInput = jarIterator1.next();
                // 重命名输出文件（同目录copyFile会冲突）
                String jarName = jarInput.getName();
                String md5Name = MD5Util.encrypt(jarInput.getFile().getAbsolutePath());
                if (jarName.endsWith(".jar")) {
                    jarName = jarName.substring(0, jarName.length() - 4);
                }
                File dest = transformInvocation.getOutputProvider().getContentLocation(jarName + md5Name, jarInput.getContentTypes(), jarInput.getScopes(), Format.JAR);
                FileUtils.copyFile(jarInput.getFile(), dest);
            }
        }
        LogUtil.log("---- code transform end ----");
    }
}
