package com.plugins.junk.method.create.code1;

import com.plugins.junk.method.create.MethodBean;
import com.plugins.junk.method.create.CreateMethodCode;
import com.plugins.junk.utils.JavassistUtils;
import com.plugins.junk.utils.LogUtil;
import com.plugins.junk.utils.RandomUtil;

import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtMethod;
import javassist.CtNewMethod;

public class MethodTemplateCode16 implements CreateMethodCode {
    @Override
    public MethodBean create(ClassPool classPool, CtClass ctClass, boolean isStatic, boolean isInterface) {
        try {
            String name = RandomUtil.getName();
            String modifier = RandomUtil.getMethodModifier(isStatic, isInterface);
            boolean boolean1 = RandomUtil.getRandom().nextBoolean();
            boolean boolean2 = RandomUtil.getRandom().nextBoolean();
            boolean boolean3 = RandomUtil.getRandom().nextBoolean();
            boolean boolean4 = RandomUtil.getRandom().nextBoolean();
            boolean boolean5 = RandomUtil.getRandom().nextBoolean();
            boolean boolean6 = RandomUtil.getRandom().nextBoolean();
            boolean boolean7 = RandomUtil.getRandom().nextBoolean();
            String method = modifier + " boolean " + name + "(boolean isVisibleToUser) {\n" +
                    JavassistUtils.insertLog(this.getClass()) +
                    "        boolean isFirstVisible = " + boolean1 + ";\n" +
                    "        boolean isFirstInvisible = " + boolean2 + ";\n" +
                    "        boolean isPrepared = " + boolean3 + ";\n" +
                    "        if (isVisibleToUser) {\n" +
                    "            if (isFirstVisible) {\n" +
                    "                isFirstVisible = false;\n" +
                    "                if (isPrepared) {\n" +
                    "                    return " + boolean4 + ";\n" +
                    "                } else {\n" +
                    "                    isPrepared = true;\n" +
                    "                }\n" +
                    "            } else {\n" +
                    "                return " + boolean5 + ";\n" +
                    "            }\n" +
                    "        } else {\n" +
                    "            if (isFirstInvisible) {\n" +
                    "                isFirstInvisible = false;\n" +
                    "                return true;\n" +
                    "            } else {\n" +
                    "                return " + boolean6 + ";\n" +
                    "            }\n" +
                    "        }\n" +
                    "        return " + boolean7 + ";\n" +
                    "    }";
            CtMethod ctMethod = CtNewMethod.make(method, ctClass);
            return new MethodBean(ctMethod) {
                @Override
                public String call() {
                    boolean nextBoolean = RandomUtil.getRandom().nextBoolean();
                    return name + "(" + nextBoolean + ");";
                }
            };
        } catch (CannotCompileException e) {
            LogUtil.error("[create method failed]: %s", e.getMessage());
        }
        return null;
    }


    public boolean setUserVisibleHint(boolean isVisibleToUser) {
        boolean isFirstVisible = false;
        boolean isFirstInvisible = false;
        boolean isPrepared = false;
        if (isVisibleToUser) {
            if (isFirstVisible) {
                isFirstVisible = false;
                if (isPrepared) {
                    return false;
                } else {
                    isPrepared = true;
                }
            } else {
                return true;
            }
        } else {
            if (isFirstInvisible) {
                isFirstInvisible = false;
                return true;
            } else {
                return false;
            }
        }
        return false;
    }
}
