package com.plugins.junk.method.create.code2;

import com.plugins.junk.method.create.MethodBean;
import com.plugins.junk.method.create.CreateMethodCode;
import com.plugins.junk.utils.JavassistUtils;
import com.plugins.junk.utils.LogUtil;
import com.plugins.junk.utils.RandomUtil;

import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtMethod;
import javassist.CtNewMethod;

public class MethodTemplateCode21 implements CreateMethodCode {

    @Override
    public MethodBean create(ClassPool classPool, CtClass ctClass, boolean isStatic, boolean isInterface) {
        try {
            String name = RandomUtil.getName();
            String modifier = RandomUtil.getMethodModifier(isStatic, isInterface);
            String abs = RandomUtil.getAbcNumber();
            String abs2 = RandomUtil.getAbcNumber();
            String judgeSymbols = RandomUtil.getJudgeSymbols();
            int i = RandomUtil.getRandom().nextInt(5);

            String method = modifier + " String[] " + name + "(String requestCacheControl) {\n" +
                    JavassistUtils.insertLog(this.getClass()) +
                    "        String[] requestCacheControls = requestCacheControl.split(\"" + abs + "\");\n" +
                    "        String[] requestCacheControls2 = new String[requestCacheControls.length];\n" +
                    "        int j = 0;\n" +
                    "        for (int i = 0; i < requestCacheControls.length; i++) {\n" +
                    "            String s = requestCacheControls[i];\n" +
                    "            if (s == null) {\n" +
                    "                continue;\n" +
                    "            }\n" +
                    "            if (s.indexOf(\"" + abs2 + "\") " + judgeSymbols + " " + i + ") {\n" +
                    "                requestCacheControls2[j] = s;\n" +
                    "                j++;\n" +
                    "            }\n" +
                    "        }\n" +
                    "        return requestCacheControls2;" +
                    "    }";
            CtMethod ctMethod = CtNewMethod.make(method, ctClass);
            return new MethodBean(ctMethod) {
                @Override
                public String call() {
                    String content = RandomUtil.getString();
                    return name + "(\"" + content + "\");";
                }
            };
        } catch (CannotCompileException e) {
            LogUtil.error("[create method failed]: %s", e.getMessage());
        }
        return null;
    }

    private String[] template(String requestCacheControl) {
        String[] requestCacheControls = requestCacheControl.split(",");
        String[] requestCacheControls2 = new String[requestCacheControls.length];
        int j = 0;
        for (int i = 0; i < requestCacheControls.length; i++) {
            String s = requestCacheControls[i];
            if (s == null) {
                continue;
            }
            if (s.indexOf("s") >= 0) {
                requestCacheControls2[j] = s;
                j++;
            }
        }
        return requestCacheControls2;
    }


}
