package com.plugins.junk.method.create.code2;

import com.plugins.junk.method.create.MethodBean;
import com.plugins.junk.method.create.CreateMethodCode;
import com.plugins.junk.utils.JavassistUtils;
import com.plugins.junk.utils.LogUtil;
import com.plugins.junk.utils.RandomUtil;

import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtMethod;
import javassist.CtNewMethod;

public class MethodTemplateCode26 implements CreateMethodCode {

    @Override
    public MethodBean create(ClassPool classPool, CtClass ctClass, boolean isStatic, boolean isInterface) {
        try {
            String name = RandomUtil.getName();
            String modifier = RandomUtil.getMethodModifier(isStatic, isInterface);
            String judgeSymbols1 = RandomUtil.getJudgeSymbols();
            String judgeSymbols2 = RandomUtil.getJudgeSymbols();
            String judgeSymbols3 = RandomUtil.getJudgeSymbols();
            int i = RandomUtil.getRandom().nextInt(5);
            int i1 = RandomUtil.getRandom().nextInt(10);
            int i2 = RandomUtil.getRandom().nextInt(10);
            int i3 = RandomUtil.getRandom().nextInt(9)+1;

            String logic1 = RandomUtil.getLogicSymbols();
            String logic2 = RandomUtil.getLogicSymbols();
            String logic3 = RandomUtil.getLogicSymbols();

            String method = modifier + " int " + name + "(String[] sourceList, String[] entryList) {\n" +
                    JavassistUtils.insertLog(this.getClass()) +
                    "        if (sourceList == null "+logic1+" entryList == null "+logic2+" sourceList.length " + judgeSymbols1 + " " + i1 + " "+logic3+" entryList.length " + judgeSymbols2 + " " + i2 + ") {\n" +
                    "            return " + i + ";\n" +
                    "        }\n" +
                    "        int sourceCount = sourceList.length;\n" +
                    "        for (int i = 0; i < entryList.length; i++) {\n" +
                    "            String entry = entryList[i];\n" +
                    "            if (entry.length() "+judgeSymbols3+" "+i3+") {\n" +
                    "                sourceCount++;\n" +
                    "            }" +
                    "        }\n" +
                    "        return Math.abs(sourceCount - sourceList.length);\n" +
                    "    }";

            CtMethod ctMethod = CtNewMethod.make(method, ctClass);
            return new MethodBean(ctMethod){
                @Override
                public String call() {
                    String arrayName1 = "yf6dhfj";
                    String array1 = RandomUtil.getStringArray(arrayName1, RandomUtil.getRandom().nextInt(2) + 1);
                    String arrayName2 = "yy43t4yu4";
                    String array2 = RandomUtil.getStringArray(arrayName2, RandomUtil.getRandom().nextInt(2) + 1);
                    return array1 +
                            array2 +
                            name + "(" + arrayName1 + "," + arrayName2 + ");";
                }
            };
        } catch (CannotCompileException e) {
            LogUtil.error("[create method failed]: %s", e.getMessage());
        }
        return null;
    }

    private int template(String[] sourceList, String[] entryList) {
        if (sourceList == null || entryList == null || sourceList.length == 0 || entryList.length == 0) {
            return 0;
        }
        int sourceCount = sourceList.length;
        for (int i = 0; i < entryList.length; i++) {
            String entry = entryList[i];
            if (entry.length() > 5) {
                sourceCount++;
            }
        }
        return Math.abs(sourceCount - sourceList.length);
    }


}
