package com.plugins.junk.method.create.code2;

import com.plugins.junk.method.create.MethodBean;
import com.plugins.junk.method.create.CreateMethodCode;
import com.plugins.junk.utils.JavassistUtils;
import com.plugins.junk.utils.LogUtil;
import com.plugins.junk.utils.RandomUtil;

import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtMethod;
import javassist.CtNewMethod;

public class MethodTemplateCode27 implements CreateMethodCode {

    @Override
    public MethodBean create(ClassPool classPool, CtClass ctClass, boolean isStatic, boolean isInterface) {
        try {
            String name = RandomUtil.getName();
            String modifier = RandomUtil.getMethodModifier(isStatic, isInterface);

            String method = modifier + " String[] " + name + "(String[] sourceList) {\n" +
                    JavassistUtils.insertLog(this.getClass()) +
                    "        int sourceListSize = sourceList.length;\n" +
                    "        for (int i = 0; i < sourceListSize; i++) {\n" +
                    "            for (int j = (i + 1); j < sourceListSize; j++) {\n" +
                    "                if (sourceList[i].equals(sourceList[j])) {\n" +
                    "                    sourceList[j] = \"\";\n" +
                    "                    sourceListSize = sourceList.length;\n" +
                    "                    j--;\n" +
                    "                }\n" +
                    "            }\n" +
                    "        }\n" +
                    "        return sourceList;\n" +
                    "    }";

            CtMethod ctMethod = CtNewMethod.make(method, ctClass);
            return new MethodBean(ctMethod) {
                @Override
                public String call() {
                    String arrayName1 = "yf6dhfj";
                    String array1 = RandomUtil.getStringArray(arrayName1);
                    return array1 +
                            name + "(" + arrayName1 + ");";
                }
            };
        } catch (CannotCompileException e) {
            LogUtil.error("[create method failed]: %s", e.getMessage());
        }
        return null;
    }

    private String[] template(String[] sourceList) {
        int sourceListSize = sourceList.length;
        for (int i = 0; i < sourceListSize; i++) {
            for (int j = (i + 1); j < sourceListSize; j++) {
                if (sourceList[i].equals(sourceList[j])) {
                    sourceList[j] = "";
                    sourceListSize = sourceList.length;
                    j--;
                }
            }
        }
        return sourceList;
    }


}
