package com.plugins.junk.method.create.code3;

import com.plugins.junk.method.create.CreateMethodCode;
import com.plugins.junk.method.create.MethodBean;
import com.plugins.junk.utils.JavassistUtils;
import com.plugins.junk.utils.LogUtil;
import com.plugins.junk.utils.RandomUtil;

import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtMethod;
import javassist.CtNewMethod;

public class MethodTemplateCode46 implements CreateMethodCode {
    @Override
    public MethodBean create(ClassPool classPool, CtClass ctClass, boolean isStatic, boolean isInterface) {
        try {
            String name = RandomUtil.getName();
            String modifier = RandomUtil.getMethodModifier(isStatic, isInterface);
            int i1 = RandomUtil.getRandom().nextInt(1280) + 10;
            int i2 = RandomUtil.getRandom().nextInt(960) + 10;
            int i3 = RandomUtil.getRandom().nextInt(10);
            int i4 = RandomUtil.getRandom().nextInt(10);
            int i5 = RandomUtil.getRandom().nextInt(10);
            String judge1 = RandomUtil.getJudgeSymbols();
            String judge2 = RandomUtil.getJudgeSymbols();
            String judge3 = RandomUtil.getJudgeSymbols();
            String judge4 = RandomUtil.getJudgeSymbols();

            String logic1 = RandomUtil.getLogicSymbols();
            String logic2 = RandomUtil.getLogicSymbols();

            String method = modifier + " int " + name + "(int bitWidth, int bitHeight) {\n" +
                    JavassistUtils.insertLog(this.getClass()) +
                    "        int imageHeight = " + i1 + ";\n" +
                    "        int imageWidth = " + i2 + ";\n" +
                    "        int ratio = " + i3 + ";\n" +
                    "        if (bitWidth " + judge1 + " bitHeight " + logic1 + " bitWidth " + judge2 + " imageWidth) {\n" +
                    "            ratio = bitWidth / imageWidth;\n" +
                    "        } else if (bitWidth " + judge3 + " bitHeight " + logic2 + " bitHeight " + judge4 + " imageHeight) {\n" +
                    "            ratio = bitHeight / imageHeight;\n" +
                    "        }\n" +
                    "        if (ratio " + judge2 + " " + i4 + ")\n" +
                    "            ratio = " + i5 + ";\n" +
                    "        return ratio;" +
                    "    }";

            CtMethod ctMethod = CtNewMethod.make(method, ctClass);
            return new MethodBean(ctMethod) {
                @Override
                public String call() {
                    int i1 = RandomUtil.getRandom().nextInt(100) + 10;
                    int i2 = RandomUtil.getRandom().nextInt(100) + 10;
                    return name + "(" + i1 + "," + i2 + ");";
                }
            };
        } catch (CannotCompileException e) {
            LogUtil.error("[create method failed]: %s", e.getMessage());
        }
        return null;
    }

    public static int template(int bitWidth, int bitHeight) {
        int imageHeight = 1280;
        int imageWidth = 960;
        int ratio = 1;
        if (bitWidth > bitHeight && bitWidth > imageWidth) {
            ratio = bitWidth / imageWidth;
        } else if (bitWidth < bitHeight && bitHeight > imageHeight) {
            ratio = bitHeight / imageHeight;
        }
        if (ratio <= 0)
            ratio = 1;
        return ratio;
    }
}
