package com.plugins.junk.method.create.code3;

import com.plugins.junk.method.create.CreateMethodCode;
import com.plugins.junk.method.create.MethodBean;
import com.plugins.junk.utils.JavassistUtils;
import com.plugins.junk.utils.LogUtil;
import com.plugins.junk.utils.RandomUtil;

import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtMethod;
import javassist.CtNewMethod;

public class MethodTemplateCode48 implements CreateMethodCode {
    @Override
    public MethodBean create(ClassPool classPool, CtClass ctClass, boolean isStatic, boolean isInterface) {
        try {
            String name = RandomUtil.getName();
            String modifier = RandomUtil.getMethodModifier(isStatic, isInterface);
            int i1 = RandomUtil.getRandom().nextInt(100);
            int i2 = RandomUtil.getRandom().nextInt(10)+1;
            int i3 = RandomUtil.getRandom().nextInt(10)+1;
            String judge1 = RandomUtil.getJudgeSymbols();
            String judge2 = RandomUtil.getJudgeSymbols();
            String calculation1 = RandomUtil.getCalculationSymbols();
            String calculation2 = RandomUtil.getCalculationSymbols();

            String method = modifier + " String " + name + "(String str, int length, String dot) {\n" +
                    JavassistUtils.insertLog(this.getClass()) +
                    "        int temp = 0;\n" +
                    "        StringBuilder sb = new StringBuilder(length);\n" +
                    "        char[] ch = str.toCharArray();\n" +
                    "        for (int i = 0; i < ch.length; i++) {\n" +
                    "            char c =ch[i];\n" +
                    "            sb.append(c);\n" +
                    "            if (c "+judge1+" "+i1+") {\n" +
                    "                temp "+calculation1+"= "+i2+";\n" +
                    "            } else {\n" +
                    "                temp "+calculation2+"= "+i3+";\n" +
                    "            }\n" +
                    "            if (temp "+judge2+" length) {\n" +
                    "                if (dot != null) {\n" +
                    "                    sb.append(dot);\n" +
                    "                }\n" +
                    "                break;\n" +
                    "            }\n" +
                    "        }\n" +
                    "        return sb.toString();" +
                    "    }";

            CtMethod ctMethod = CtNewMethod.make(method, ctClass);
            return new MethodBean(ctMethod) {
                @Override
                public String call() {
                    String s1 = RandomUtil.getString();
                    String s2 = RandomUtil.getString();
                    int i = RandomUtil.getRandom().nextInt(10);
                    return name + "(\""+s1+"\", " + i + ", \""+s2+"\");";
                }
            };
        } catch (CannotCompileException e) {
            LogUtil.error("[create method failed]: %s", e.getMessage());
        }
        return null;
    }

    public static String template(String str, int length, String dot) {
        int temp = 0;
        StringBuilder sb = new StringBuilder(length);
        char[] ch = str.toCharArray();
        for (int i = 0; i < ch.length; i++) {
            char c =ch[i];
            sb.append(c);
            if (c > 256) {
                temp += 2;
            } else {
                temp += 1;
            }
            if (temp >= length) {
                if (dot != null) {
                    sb.append(dot);
                }
                break;
            }
        }
        return sb.toString();
    }
}
