package com.plugins.junk.method.create.code3;

import com.plugins.junk.method.create.CreateMethodCode;
import com.plugins.junk.method.create.MethodBean;
import com.plugins.junk.utils.JavassistUtils;
import com.plugins.junk.utils.LogUtil;
import com.plugins.junk.utils.RandomUtil;

import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtMethod;
import javassist.CtNewMethod;

public class MethodTemplateCode52 implements CreateMethodCode {
    @Override
    public MethodBean create(ClassPool classPool, CtClass ctClass, boolean isStatic, boolean isInterface) {
        try {
            String name = RandomUtil.getName();
            String modifier = RandomUtil.getMethodModifier(isStatic, isInterface);
            int i1 = RandomUtil.getRandom().nextInt(10);
            int i2 = RandomUtil.getRandom().nextInt(10) + 1;
            int i3 = RandomUtil.getRandom().nextInt(10);
            int i4 = RandomUtil.getRandom().nextInt(3) + 1;
            int i5 = RandomUtil.getRandom().nextInt(3) + 1;

            String judge1 = RandomUtil.getJudgeSymbols();
            String judge2 = RandomUtil.getJudgeSymbols();
            String judge3 = RandomUtil.getJudgeSymbols();

            String calculation = RandomUtil.getCalculationSymbols();
            String calculation2 = RandomUtil.getCalculationSymbols();

            String method = modifier + " int[] " + name + "(int includedStart, int excludedEnd, int step) {\n" +
                    JavassistUtils.insertLog(this.getClass()) +
                    "       if (includedStart " + judge3 + " excludedEnd) {\n" +
                    "            int tmp = includedStart;\n" +
                    "            includedStart = excludedEnd;\n" +
                    "            excludedEnd = tmp;\n" +
                    "        }\n" +
                    "        if (step " + judge1 + " " + i1 + ") {\n" +
                    "            step = " + i2 + ";\n" +
                    "        }\n" +
                    "        int deviation = excludedEnd " + calculation + " includedStart;\n" +
                    "        int length = deviation / step;\n" +
                    "        if (deviation % step " + judge2 + " " + i3 + ") {\n" +
                    "            length = " + i4 + ";\n" +
                    "        }\n" +
                    "        length = Math.abs(length);\n" +
                    "        if (length > "+i5+") {\n" +
                    "            length = "+i5+";\n" +
                    "        }" +
                    "        int[] range = new int[length];\n" +
                    "        for (int i = 0; i < length; i++) {\n" +
                    "            range[i] = includedStart;\n" +
                    "            includedStart " + calculation2 + "= step;\n" +
                    "        }\n" +
                    "        return range;" +
                    "    }";

            CtMethod ctMethod = CtNewMethod.make(method, ctClass);
            return new MethodBean(ctMethod) {
                @Override
                public String call() {
                    int ii1 = RandomUtil.getRandom().nextInt(100) + 1;
                    int ii2 = RandomUtil.getRandom().nextInt(100) + 1;
                    int ii3 = RandomUtil.getRandom().nextInt(100) + 1;
                    return name + "(" + ii1 + ", "+ii2+", "+ii3+");";
                }
            };
        } catch (CannotCompileException e) {
            LogUtil.error("[create method failed]: %s", e.getMessage());
        }
        return null;
    }

    public static int[] template(int includedStart, int excludedEnd, int step) {
        if (includedStart > excludedEnd) {
            int tmp = includedStart;
            includedStart = excludedEnd;
            excludedEnd = tmp;
        }
        if (step <= 0) {
            step = 1;
        }
        int deviation = excludedEnd - includedStart;
        int length = deviation / step;
        if (deviation % step != 0) {
            length += 1;
        }
        length = Math.abs(length);
        if (length > 5) {
            length = 2;
        }
        int[] range = new int[length];
        for (int i = 0; i < length; i++) {
            range[i] = includedStart;
            includedStart += step;
        }
        return range;
    }
}
