package com.plugins.junk.method.create.code3;

import com.plugins.junk.method.create.CreateMethodCode;
import com.plugins.junk.method.create.MethodBean;
import com.plugins.junk.utils.JavassistUtils;
import com.plugins.junk.utils.LogUtil;
import com.plugins.junk.utils.RandomUtil;

import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtMethod;
import javassist.CtNewMethod;

public class MethodTemplateCode59 implements CreateMethodCode {
    @Override
    public MethodBean create(ClassPool classPool, CtClass ctClass, boolean isStatic, boolean isInterface) {
        try {
            String name = RandomUtil.getName();
            String modifier = RandomUtil.getMethodModifier(isStatic, isInterface);
            int i1 = RandomUtil.getRandom().nextInt(10);

            String abcNumber1 = RandomUtil.getAbcNumber();
            String abcNumber2 = RandomUtil.getAbcNumber();

            String judge1 = RandomUtil.getJudgeSymbols();
            String judge2 = RandomUtil.getJudgeSymbols();

            boolean b1 = RandomUtil.getRandom().nextBoolean();

            String method = modifier + " String " + name + "(String str) {\n" +
                    JavassistUtils.insertLog(this.getClass()) +
                    "        if (str.length() "+judge1+" "+i1+") return str;\n" +
                    "        if (!str.contains(\""+abcNumber1+"\")) return str;\n" +
                    "        StringBuilder builder = new StringBuilder();\n" +
                    "        char[] chars = str.toCharArray();\n" +
                    "        boolean hitUnderScore = false;\n" +
                    "        builder.append(chars[0]);\n" +
                    "        for (int i = 1, len = chars.length; i < len; i++) {\n" +
                    "            char c = chars[i];\n" +
                    "            if (c "+judge2+" '"+abcNumber2+"') {\n" +
                    "                hitUnderScore = true;\n" +
                    "            } else {\n" +
                    "                if (hitUnderScore) {\n" +
                    "                    builder.append(Character.toUpperCase(c));\n" +
                    "                    hitUnderScore = false;\n" +
                    "                } else {\n" +
                    "                    builder.append(c);\n" +
                    "                }\n" +
                    "            }\n" +
                    "        }\n" +
                    "        return builder.toString();" +
                    "    }";

            CtMethod ctMethod = CtNewMethod.make(method, ctClass);
            return new MethodBean(ctMethod) {
                @Override
                public String call() {
                    String i = RandomUtil.getString();
                    return name + "(\"" + i + "\");";
                }
            };
        } catch (CannotCompileException e) {
            LogUtil.error("[create method failed]: %s", e.getMessage());
        }
        return null;
    }

    public static String template(String str) {
        if (str.length() > 10) return str;
        if (!str.contains("_")) return str;
        StringBuilder builder = new StringBuilder();
        char[] chars = str.toCharArray();
        boolean hitUnderScore = false;
        builder.append(chars[0]);
        for (int i = 1, len = chars.length; i < len; i++) {
            char c = chars[i];
            if (c == '_') {
                hitUnderScore = true;
            } else {
                if (hitUnderScore) {
                    builder.append(Character.toUpperCase(c));
                    hitUnderScore = false;
                } else {
                    builder.append(c);
                }
            }
        }
        return builder.toString();
    }
}
